#include "hp25lp.h"
#include "act.h"
#include "display.h"
#include "sst25pf040.h"

extern uint8_t rightshift;
extern uint16_t PauseCnt,TimerCnt;

uint8_t LEDdisplaydigit;
uint8_t Semicolon;

static uint8_t LEDdigit;
static uint8_t decimal;

// HP-01 display coding characters above 10 '.', '-', ':', 'o', '#', ' ' , semicolon is dot and minus together
const char digittab01[6] = { 0x1F, 0x29, 0x39, 0x0c, 0x39, 0x0F };

// show n digits 32-bit octal number data at digit position
void DisplayOct(uint32_t data,uint8_t digit,uint8_t digits)
{
	for(uint8_t i=digits;i>0;i--)
	{
		act_reg[WSIZE-i-digit]=data & 0x07;
		data>>=3;
	}
}

// show n digits 32-bit hex number data at digit position
void DisplayHex(uint32_t data,uint8_t digit,uint8_t digits)
{
	uint8_t a;
	
	for(uint8_t i=digits;i>0;i--)
	{
		a=data & 0x0f;
		if(a>=10)
		  a+='A'-10;  // show A B C D E F
		act_reg[WSIZE-i-digit]=a;
		data>>=4;
	}
}

// zeigt dezimalzahl zwei oder dreistellig mit fhrender Nullunterdrckung
void DisplayDecimal(uint8_t nr,uint8_t digit)
{
uint8_t n;

	n=nr/100;
	if(n) act_reg[WSIZE-1-digit]=n;  // supress leading zero
	nr-=n*100;
	n=nr/10;
	/*if(n)*/ act_reg[WSIZE-2-digit]=n; // supress leading zero
	act_reg[WSIZE-3-digit]=nr%10;
}


// Show 32-bit number as either hex or octal right justified
void ShowHex(uint32_t n)
{
	ClearInfo();

	if(flags2 & F_OCTMODE)
	{
		DisplayOct(n,0,11); // use 11 digits
	    act_reg[WSIZE-1-11]='O'; // show o
	} else
	{
		DisplayHex(n,3,8); // use 8 digits
	    act_reg[WSIZE-1-11]='H'; // show H
	}
}

void ShowTrigFunction()
{
uint8_t *pt=(uint8_t *)ACT_RAM;
  trigmode=0; // HP22 doesnt have trig functions

  if(HPType==0x31)
  {
     // act_s & 1<<14 = GRD  1<<12 = RAD wenn beide flags gesetzt hat GRD vorrang
      if(act_s & 1<<14)
        trigmode=2; // GRD
      else
        if(act_s & 1<<12) trigmode=1; //RAD
  }
  if(HPType==0x32)
  {
     // act_s & 1<<14 = GRD  1<<12 = RAD wenn beide flags gesetzt hat RAD vorrang
      if(act_s & 1<<12)
        trigmode=1; // RAD
      else
        if(act_s & 1<<14) trigmode=2; //GRD
  }
  if(HPType==0x34)
	  trigmode=pt[31*7+6] >>4; // 0=DEG 1=RAD 2=GRD
  if(HPType==0x33)
	  trigmode=pt[8*7+6] >>4; // 0=DEG 1=RAD 2=GRD
  if(HPType==0x67)
  {
    if(act_s & 1<< 0) trigmode=1; // RAD
    if(act_s & 1<<14) trigmode=2; // GRD
  }
  if(HPType==0x21)
  {
    if(flags & F_SLIDERRIGHT)  // HP21 uses slider to select between DEG and RAD
      trigmode=1; //RAD
  }
  if(HPType==0x25)
    trigmode=2-(act_m[WSIZE/2-1]>>4);
  if(HPType==0x27)
    trigmode=act_n[WSIZE/2-1]; // HP-27 DEG=0 RAD=1 GRD=2 // HP-25 DEG=2 RAD=1 GRD=0
  if(HPType==0x29) // || HPType==0x19)
    trigmode=pt[46*7] & 0x0F;    // ram 46[0] DEG=0 RAD=1 GRD=2

#ifdef SPICE
	if((LEDdisplaydigit==10 && trigmode & 1) || (LEDdisplaydigit==9 && trigmode & 2))  // show RAD GRD Mode GRD=0 RAD=1 DEG=2 in digit 9 und 10
#else
	if((LEDdisplaydigit==11 && trigmode & 1) || (LEDdisplaydigit==10 && trigmode & 2))  // show RAD GRD Mode GRD=0 RAD=1 DEG=2
#endif
	  LEDdigit|=0x80;
}

void ShowPrefix()
{
  if(LEDdisplaydigit==0)
	{
// HP-32 P=12 no prefix p=10 f prefix  p=11 g prefix, HP-34 p=9 h prefix
	  if((act_s & annuncmask) || (HPType==0x32 || HPType==0x34 || HPType==0x38) && act_p>=8 && act_p<=11) //  || act_c[3]==0x0b // prefix f g STO RCL links
			LEDdigit|=0x80;
  }
}

//#pragma interrupt_level 1  // disable duplication
uint8_t GetDisplayDigit(uint8_t n)
{
uint8_t a,b,i,exp;

  LEDdigit=' ';

  a=act_a[WSIZE-1-n];
	b=act_b[WSIZE-1-n];

  if(HPType==0x67)
  {
		if(n==0) // check whether act_b is zero, necessary to show program code when R/S or SST is pressed
		{
	    classicflags|=F_BZERO;
			for(i=0;i<WSIZE;i++)
				if(act_b[i]!=0) // if no exponent visible loop terminates after testting act_b[0], else after finding decimal point
				{
          classicflags&=~F_BZERO; // non zero, must be number with or without exponent in RUN mode
					break;
				}
		}

		if(!(act_flags & AF_RUNMODE) || (classicflags & F_BZERO)) // Program mode or R/S or SST BST show program number and step
		{
			if(act_a[WSIZE-1]!=0x0E && n>=3)  // show program code after 3-digit step nummer, or show digits as is if "Error" displayed
	  		a=act_a[WSIZE-3-n]; // show program code left shifted by two digits, omit digits 3 4
      LEDdigit = a; // b is always 0
		}
		else // AF_RUNMODE
		{
			if(n==0) // first digit shows mantissa sign or blank or text
			{
				decimal=FALSE; // decimal dot not encountered
				if(!(act_a[2] & 1))
					LEDdigit='-';  // display driver 0x20(or 0x0f) will be show  blank, 0x2c(or 0x28-0x2f) will show Minus
			}
			else // next digits show mantissa and exponent in RUN mode
			{
				exp= act_flags & AF_RUNMODE && n>=MAXDIGITS-3 && act_b[0]==0; // exponent visible ? b=2 when exponent not visible

				if(!exp)  // if not exponent
				{
					if(decimal) // dezimalpunkt bereits gefunden, dann ein digit berspringen?
					  n++;
					if(n<=11)
					{
						b=act_b[WSIZE-n];
		 				a=act_a[WSIZE-n]; // first mantissa digit is located at [WSIZE-1]
		        if((b & 3) == 0)  // normal digit 
     			     LEDdigit = a;
					}
				}
				else
				{
          uint8_t *pt=act_b;
          b=*(pt+WSIZE-3-n); // act_b[(WSIZE-3)-n];
					a=act_a[(WSIZE-3)-n]; // show signed exponent
					if(n==9)  // show exponent sign
					{
		        if(a != 0x0f && (a & 0x0a) != 0) // a is 0xf when Error displayed, exponent sign is negativ when bit 1 or 3 is set
     	        LEDdigit =  '-';
					}
					else // exponent
					{
	   	      LEDdigit = a;
					}
				}
			}
      if (!decimal)
			{
				b=act_b[WSIZE-1-n];
				if(b==3 || b==0x0f) // nchstes digit Dezimalpunkt oder blank? dann hier bereits dezimalpunkt anzeigen
				{
					if(b==3) // decimalpunkt, blank kommt nur vor bei blinkendem Decimalpunkt -x- Anzeige
            LEDdigit| = 0x80;
					decimal=TRUE; // nchstes digit berspringen
				}
			}
		}    
  } else
  if(TypeFlags & TF_CLASSIC)
  {
			exp= act_flags & AF_RUNMODE && n>=MAXDIGITS-3 && act_b[WSIZE-1-11]<=7; // exponent visible ? HP-45 exponent sign act_b=9 if blank 0=if exponent visible
			if(exp || classicflags & F_TIMER || !(act_flags & AF_RUNMODE)) // exponent visible or HP-55 Timer or Program mode
      {
//				n+=2; 
			  a=act_a[WSIZE-3-n];  // shift left rightmost 3 digits by two digits
			  b=act_b[WSIZE-3-n];
      }

      if (b <= 7)
      {
         if ((n == 0) || ((exp || !(act_flags & AF_RUNMODE)) && n == MAXDIGITS-3)) // 3. digit von rechts ist immer blank oder minus
           LEDdigit = a >= 8 ? '-' : ' '; // minus or blank
         else
           LEDdigit = a;
         if (b == 2)
           LEDdigit|=0x80; // add decimal dot
      }
  } else
#ifdef HP01
  if(HPType==0x01)  // show 9 digits, first 3 digits are always blank
  {
          if( n>=2 && n<=10)
          {
    	      a=act_dsp[WSIZE-1-n];
            if(a==12)   // colon is character 12
             a=':'-16;
         		LEDdigit=a<10 ? a: digittab01[a-10];
          }
  } else
#endif // 01
  if(TypeFlags & TF_SPICE)
  {
    if(flags & F_SHOWMNEMONIC /* && HPType==0x34*/) // Sonderbehandlung fr HP-34 schiebe letzte zwei Zeichen  um ein digit nach rechts 
    {
      if(n<=4 && HPType==0x34)   // don't shift HP-33
        n++;    // shift program number 1 digit to the left, because number has 3 digits
#ifndef SPICE
      if(n>=MAXDIGITS-3) // make use of 12-digit Woodstock display
        n--;   // shift key code 1 digit to the right
#endif
      a=act_a[WSIZE-1-n];
      b=act_b[WSIZE-1-n];
      goto L1;
    }
    if(n<MAXDIGITS-1)  // SPICE has only 11 digits
    {
          if (n == 1)
            b &= ~4;  // remove minus sign if n=1, is already read when n=0			    if(n==0)  // leftmost digit sign
L1:
          if(n==0)
          {
					  if(act_b[WSIZE-1-1] & 4) LEDdigit='-';  // sign is coded in first digit when b & 4 is set// - or  blank
          }
  			  else
	  		  {
		  		  if(b & 4)  // sign exponent b=6
            {
               if(a & 8) LEDdigit='-'; // set sign if a=9 or a=0x0e
            }
				    else
				    {
					  	LEDdigit=a;
#ifdef SPICE
              if(b & 1) // show separate commas and decimal dots in Spice display
                LEDdigit|=0x80; // add decimal point
  					  if(b & 2)
                Semicolon|=1<<n; // add comma/semicolon
#else
						  if((b & 3)==3) // add decimal point if dot, and not comma
						  {
							  b=act_flags & AF_RUNMODE ? 0 : 1; // show only dot not comma
						  } 
//						  if(flags1 & F_LOWBATT && act_flags & AF_RUNMODE) // show decimal dots inverted if low power
//						    b^=1;
//              if((b & 7) == 1) // show decimal point not commas
//                LEDdigit|=0x80; // add decimal point
              if(b & 3) // show also commas as dots in display in Woodstock display
                LEDdigit|=0x80; // add decimal point
#endif
				    }
          }   
	  }
  } else
 // Woodstock
  {
    if(b & 2)
    {
      if(a==9) LEDdigit='-';  // sign ?
    }
    else
      LEDdigit=a;

    if(b & 1)
      LEDdigit|=0x80; // add decimal point
  }

  return LEDdigit;
}

// Woodstock 12-digit display, HP01 9-digit,  HP-19C 13-digit
// show ACT X register act_a act_b or act_c when mantissa is shown, set digit according to displaydigit
inline void ShowACT()
{
  uint8_t n;

	if(act_flags & AF_DISPLAY_ON && !(flags2 & F_WAITIDLE)) // display on ? suppress display while rightadjust and other actions is performed
	{
		n=LEDdisplaydigit;  // 0-MAXDIGITS-1

#ifdef RIGHTSHIFT
	  if(rightshift && act_flags & AF_RUNMODE)  // check RUNMODE because rightshift is not reset after switch to PRGM mode
		{
			n=LEDdisplaydigit-rightshift;
			if(LEDdisplaydigit<rightshift)
				n+=MAXDIGITS;
		}
#endif
    GetDisplayDigit(n);
	
// ShowMnemonic
    if(user_flags & UF_SHOWMNEMONIC && flags & F_SHOWMNEMONIC)
    {
#ifdef SPICE
      if(n>=4 && n<MAXDIGITS-3)  // show Program step nr and operand 5 digits
#else
      if(n>=4 && n<MAXDIGITS-2)  // show Program step nr and operand 6 digits
#endif
       	LEDdigit=act_reg[WSIZE-1-n+3]; // skip first digit [WSIZE-1] is always blank
   }

// ShowAnnunciator
	  if(user_flags & UF_SHOWANNUNC && !(keyflags & KF_SHOWPROGRAM) && !(keyflags & KF_REPEATKEY))
    {
      ShowPrefix();
	 		if(act_flags & AF_RUNMODE && !(act_s & RunBit)) // dont show trig mode in PRGM Mode or when program is running
        ShowTrigFunction();
    }
	}
}

// Berechne die Display Anzeige. Das Ergebnis wird in act_dsp gepseichert
// Bei SPICE wird ein zustzliches bits bentigt.
void DoDisplay()
{
  Semicolon=0; // fr SPICE display 8 Komma bits fr digit 1-8

  for(LEDdisplaydigit=0;LEDdisplaydigit<MAXDIGITS;LEDdisplaydigit++)
  {
		LEDdigit=' '; // digit off

    if(flags & F_SHOWINFO)
  	{
	    LEDdigit=act_reg[WSIZE-1-LEDdisplaydigit];
  	}
  	else if(user_flags & UF_STEADYDISP && act_s & RunBit)  // program running ?
  	{
      if(PauseCnt) // whrend Pause ACT anzeigen und digits in act_reg speichern
      {
     	  TimerCnt=0; // Timer fr blinkenden Punkt in der Anzeige bei Pause zurcksetzen
     	  goto L2;
      }
      else
      {
 	      LEDdigit=act_dsp[WSIZE-1-LEDdisplaydigit];
     	  if(LEDdisplaydigit==MAXDIGITS-1)
         {
           if((TimerCnt & 31)<16)  // blinkenden Punkt anzeigen whrend Programm luft
	    	    LEDdigit|=0x80;
  	       else
    		    LEDdigit&=~0x80;
         }
      }
  	}
		else
  	{
L2:
		   ShowACT();
  	}
    act_dsp[WSIZE-1-LEDdisplaydigit]=LEDdigit;
  }
}
