#include "hp25lp.h"
#include "act.h"
#include "bcd.h"
#include "display.h"
#include "hexentry.h"
#include "keyboard.h"

extern const uint8_t AlphaKey[];

uint32_t HexNumber;  // Number for hex entry

#ifdef HEXENTRY

static uint8_t hexentrydigit;

// Convert BCD X register and show as hex number
static void ConvertBCD()
{
uint8_t *pt;

	pt=act_c; // 21/27/67 has X register in act_c
  if(HPType==0x29) // || HPType==0x19)
  {
	  src=(uint8_t *)ACT_RAM+47*7;  // X register in register 47,also in act_m
    goto L1;
  } else if(HPType==0x33)
  {
    src=(uint8_t *)act_m;
    goto L1;
  } else if(TypeFlags & TF_ACTN) // 22/25/31/32/34/37/38 has X register in act_n HPType!=0x21 && HPType!=0x27 && HPType!=0x67)
  {
    src=(uint8_t *)act_n;
L1:
    dest=act_reg;
    pt=act_reg;
	  reg_decompress();
  }
	HexNumber=ConvertBCD2Hex(pt);
	ShowHex(HexNumber);
}

void EnterHexEntry()
{
 		hexentrydigit=0; // clears entry at first number
		ConvertBCD();  // 21,27,34,67
}

void LeaveHexEntry()
{
  uint8_t *pt=act_n;

 	keyflags|=KF_CLEARPREFIX|KF_ALLOWKEY;

  if(HPType==0x33)
		pt=act_m; // X register is located in m in HP-33
  if(HPType==0x34)
  {
		act_p=9; // set h prefix
		keycode=0160;  //h ABS normalize display
  }
  if(HPType==0x29) // || HPType==0x19)
     pt=(uint8_t *)ACT_RAM+47*7; // X register is located in external RAM

  if(TypeFlags & TF_21_27_67) // HPType==0x021 || HPType==0x27 || HPType==0x67)
  {
		ConvertHex2BCD(act_reg,HexNumber);
		dest=act_c; src=act_reg; reg_decompress();
    if(HPType==0x67)
    {
			act_s|=1<<13 | 1<<8 | 1<<6 | 1<<4 | 1<<9; // set h prefix  bit9 is stack lift bit 13=prefix bit8=h prefix
			act_s&=~(1<<12); // reset digit entry mode
			keycode=0x30; // CLX key = h DEL clear prefix and show X register
			act_press_key(keycode);
			keyflags&=~KF_CLEARPREFIX;
    }
	} else
		ConvertHex2BCD(pt,HexNumber); // X register is located in n in HP-22,HP-25,HP30s
}

// wird aufgerufen im Hex Modus bei Tastendruck 
void DoHexEntry()
{
uint8_t i,a;

	if(keyindex==CLXKEY) // clear entry
	{
		HexNumber=0;
		hexentrydigit=0;
	}
	else if(keyindex==CHSKEY) // clear entry
	{
		flags2^=F_OCTMODE; // Show octal
	}
  else
  {
	  if(flags2 & F_OCTMODE)  // reject unused keys
    {
      if(keyindex>7 || hexentrydigit>=11) return;  // maximum 11 digits in octal entry mode
    } else
    {
      if(hexentrydigit>=8) return;  // maximum 8 digits in hex entry mode
    }

		if(keyindex<10) // 0-9
    {
			i=keyindex;
      goto L1;
    }

	  for(i=0;i<6;i++)  // test A-F
		{
      a=AlphaKey[i];
      if(HPType==0x67) a-=0x10; // A-F in first row

			if(hpcode==a)
			{
				i+=10; // A-F -> 10-15
				goto L1;
			}
		}
	  return;

L1:
		if(hexentrydigit==0)
			  HexNumber=0;

		HexNumber<<=flags2 & F_OCTMODE ? 3 : 4;
		HexNumber+=i;
		hexentrydigit++;
	}
	ShowHex(HexNumber);
}
#endif

