#include "xc.h"
#include "hp25lp.h"
#include "act.h"
#include "sst25pf040.h"
#include "program.h"
#include "mnemonic.h"
#include "display.h"

// read Mnemonic from flash and write into act_reg
// will be used also for printing
uint8_t SetMnemonic(uint8_t n,uint16_t addr)
{
	uint8_t a,i;

  i=1;

	do
	{
    while(1)
    {
      SST25Read(TEXTPAGE, addr,&a, 1); // Address of Display Mnemonics 
      addr++;
      if(a==0xFF)
        return 0;
		  if(a==0)
        break;
			if(n==0)
  				act_reg[WSIZE-1-i++]=a; // set mnemonic maximum 5 digits
		}
	} while(n--);
  return i;
}

#ifdef MNEMONICS

// Mnemonic Display
void ShowMnemonic()
{
	uint8_t i,n;

  flags&=~F_SHOWMNEMONIC;
  if(user_flags & UF_SHOWMNEMONIC && DisplayNr==DISPCALCULATOR && !(flags3 & F_INFOTEXT) && !(act_s & RunBit)) // nicht wenn Programm luft
  {
    if(MnemonicAddr<0xFF00 && act_a[WSIZE-2]<=9) // not when Error or Mem is displayed HP-34
    {
      ClearInfo();  // lsche Puffer
      flags&=~F_SHOWINFO;
	    i=GetProgramStep();
      if(i>0)
      {
        n=GetProgramCode(i);
	      SetMnemonic(n,0x4000+MnemonicAddr); // show program step mnemonic
        flags|=F_SHOWMNEMONIC;
      }
    }
  }
}
#endif // MNEMONIC

