#include "xc.h"
#include "hp25lp.h"
#include "act.h"
#include "pcf2127.h"
#include "sst25pf040.h"

#ifdef PCF2127

#define CLKPERIOD (_XTAL_FREQ/4/1000000)  // 1 MHz SPI Clock

#ifdef HP01
uint32_t days;   // 16-bit would be only up to 65535 days from 1900 = 1900- 2079
uint8_t day,month,year;

const uint8_t DaysOfMonth[12] = { 31,28,31,30,31,30,31,31,30,31,30,31 };
#endif

static const uint8_t RTCInitTab[] = {
0x01,  // normal operation, 24h mode, SI Second Interrupt enabled
0x04,  // TSIE interrupt enabled
0x00,
// date time registers
0x00,
0x00,
0x00,
0x01,
0x00, // weekday
0x01,
0x00,  // set date to 1.1.2000
// alarm registers
0x00,
0x00,
0x00,
0x80, // disable day alarm flag
0x80, // disable weekday alarm flag
0x25 // write to CLKOUT register 1024 Hz, Watch Control Register
};

void RTCInit()
{
char buf[1];

// first instruction must be OTP refresh
  buf[0]=0x05; // 5=1024 Hz 6=1 Hz 7=High Z
  RTCWrite(0x0f,buf,1); // write to CLKOUT register 1024 Hz, Watch Control Register
  buf[0]=0x25; // 5=1024 Hz 6=1 Hz 7=High Z set OTPR
  RTCWrite(0x0f,buf,1); 
 	RTCWrite(0x00,(char *)RTCInitTab,16); // write to Control register 1-3,date, time, alarm, CLKOUT registers

// char buf[16];
// SST25Read(FCONSTANTPAGE,RTCINITTAB,buf,16);
// RTCWrite(0x00,buf,16); // write to Control register 1-3,date, time, alarm, CLKOUT registers
}

// Write data to RTC, starting with register addr.
// addr 0x00-0x1f
void RTCWrite(uint8_t addr,char *buf, uint8_t length)
{
  CE=0;
 	SSPBUF=0x20 | addr; while(BF==0);// /RW=0, subaddress 01, register address
  
  while(length--)
  {
  	SSPBUF=*buf++;   while(BF==0);
  }
  CE=1;
}

// Read data from RTC, starting with register addr.
// addr 0x00-0x1f
void RTCRead(uint8_t addr, char *buf, uint8_t length)
{
  CE=0;
 	SSPBUF=0xA0 | addr; while(BF==0);// /RW=1, subaddress 01, register address
  while(length--)
  {
  	SSPBUF=0;   while(BF==0);
    *buf++=SSPBUF;
  }
  CE=1;
}

#ifdef HP01
// Alle durch 4 teilbaren Jahre sind Schaltjahre, ausser volle Jahrhundert (sogenannte Skularjahre), mit Ausnahme der durch 400 teilbaren Jahrhunderte.
// 1900 war kein Schaltjahr, 2000 war ein Schaltjahr.

// valid days range is from 1.1.1900-31.12.2099
// Calculate day 1-31, month 1-12,year 0-199 from number of days since 1.1.1900 (days = 0)
// days remain unchanged
static void GetDateFromDays()
{
  uint16_t d; // use 16-bit days intermediate variable for smaller compile size
  uint8_t  n;

  if(days>=365) days++;  // treat 1900 as leap year to simplify calculation

  n=days/(365*4+1);  // n= no of 4 years periods
  year=n*4;
  d=days-n*(365L*4+1); // d=days % (4*365+1) d=0-1460

  if(days>=366) days--; // days not longer used, keep variable days unchanged

  if(d>=366)  // first of 4 years period is leap year
  {
    d--;
    n=d/365;
    year+=n;
    d-=n*365;
  }
	
// d=0-365 if leap year or 0-364 if normal year
 
  for(month=1;month<=12;month++)  // month 1-12
  {
     n=DaysOfMonth[month-1];
     if(month==2 && (year & 3)==0 && year!=0) n++; // if leap year add 1 day at february, 1900 is not leap year
     if(d>=n)
       d-=n;
     else
       break;
  }
  day=d+1;  // return day from 1-31
}

// Calculate days since 1.1.1900 from day 1-31, month 1-12, year 0-199
// day,month,year remain unchanged
static void GetDaysFromDate()
{
  uint8_t y,i,n;

  y=year/4;  // year from 0-199  0=1900

  days=y*(365L*4+1); // 4 years are 1461
  if(y) days--;  // first 4 years 1900-1903 are 1460 days, therefore subtract 1
  
  y=year & 3; // same as year % 4
  if(y>0)
  {
    days+=y*365;
    if(year>=4)  // 1900-1903 was not leap year period, otherwise add 1 day for first year of 4 year period
      days++;
  }

  for(i=1;i<=12;i++)   // month 1-12
  {
     n=DaysOfMonth[i-1];
     if(i==2 && (year & 3)==0 && year!=0) n++; // if leap year add 1 day at february, 1900 is not leap year
     if(month>i)
       days+=n;
     else
       break;
  }
  days+=day-1; // add remaining days within month
}
#endif

// Read date and time into register act_cl

void RTCReadDate()
{
  char buf[10];
  uint8_t i,j;

  RTCRead(3,buf,10); // read 10 registers second, minute, hour, day, weekday, month year, alarm second minute hour
  if(buf[0] & 0x80)
  {
    buf[0]&=0x7F; // reset OSF Flag
    RTCWrite(3,buf,1);
    flags4|=F_OSFERROR;
  }

//  if(buf[0]==0 && buf[1]==0) // full hour ?
//    flags4|=F_HOUR; // set hour flag
		
// will be compiled more compact than without loop
  for(i=0,j=0;i<3;i++,j++)
  {
    act_cl[i*2]=buf[j] & 0x0F; // seconds, minutes, hours
    act_cl[i*2+1]=buf[j]>>4;
    act_al[i*2]=buf[j+7] & 0x0F; // seconds
    act_al[i*2+1]=buf[j+7]>>4;
  }
  act_cl[10]=buf[3] & 0x0F; // days date is in reverse order
  act_cl[11]=buf[3]>>4;
  act_weekday= buf[4]; // weekday
  act_cl[8]=buf[5] & 0x0F; // months
  act_cl[9]=buf[5]>>4;
  act_cl[6]=buf[6] & 0x0F; // years
  act_cl[7]=buf[6]>>4;

#ifdef HP01
  day  = (buf[3]>>4)*10 + (buf[3] & 0x0f);
  month= (buf[5]>>4)*10 + (buf[5] & 0x0f);
  year = (buf[6]>>4)*10 + (buf[6] & 0x0f);

  RTCRead(0x0e,buf,1); // read weekday alarm which contains year 2000 flag
  if(buf[0] & 1)
    year+=100; // add 100 if year 2000 flag set

  GetDaysFromDate(); // convert date format to days since 1900
  for(i=0;i<6;i++)
  {
  	act_cl[6+i]= days % 10;
    days/=10;
  }
#endif
}

// Write date and time from act_cl register
void RTCWriteDate()
{
  char buf[7];

#ifdef HP01
// Get days from act_cl register as decimal number in upper 6 bytes
  days=0;
  for(uint8_t i=0;i<6;i++)
  {
    days=days*10;
    days+=act_cl[11-i];
  }
  GetDateFromDays(); // calculate day,month,year from days, considering leap years

 	buf[0]= 0x80;
  if(year>=100)
  {
   	buf[0]= 0x81;
    year-=100;
  }
  RTCWrite(0x0e,buf,1); // store year 2000 flag in unused weekday alarm register
#endif

// act_cl shows second at the right and hour in the left
  buf[0] = act_cl[0] | act_cl[1]<<4; // second
  buf[1] = act_cl[2] | act_cl[3]<<4; // minute
  buf[2] = act_cl[4] | act_cl[5]<<4; // hour
// act_cl shows day at the left and year on the right of display
  buf[3] = act_cl[10] | act_cl[11]<<4; // day
  buf[4] = act_weekday;   // weekday
  buf[5] = act_cl[8] | act_cl[9]<<4; // month
  buf[6] = act_cl[6] | act_cl[7]<<4; // year
  RTCWrite(3,buf,7);

}

// set alarm time from act-al register and activate/deactivate alarm 
void RTCSetAlarm(uint8_t activate)
{
  char buf[5];
	
  buf[0]=activate ? 0x06 : 0x04; // set TSIE AIE in control Reg 2
  RTCWrite(1,buf,1); // Write to control register 2  set or reset AIE, reset AF alarm flag
  buf[0] = act_al[0] | act_al[1]<<4; // second
  buf[1] = act_al[2] | act_al[3]<<4; // minute
  buf[2] = act_al[4] | act_al[5]<<4; // hour
  buf[3] = 0x80; // disable day alarm flag
  buf[4] = 0x80; // disable weekday alarm flag
  RTCWrite(0x0a,buf,5); // write 3 registers, alarm seconds, minutes, hours
}

#endif
