// Externes 512 kB Flash SST25PF040B
// Das flash enthlt alle Calculator ROM opcodes, Userprogramme, Userregister, Constanten, Continuous Memory

// To do :
// Userregister Banks fehlen
// Programmnamen jedes 49 byte Program hat 12 byte Programmname = 61 bytes von 64 belegt
// Continuous Memory abspeichern laden
// FlashReadWord und UserFlags schreiben

#include <string.h>
#include "xc.h"
#include "hp25lp.h"
#include "act.h"
#include "serial.h"
#include "remote.h"
#include "sst25PF040.h"

// supported calculators
// HP-01,21,22,25,27,29,31,32,33,34,37,38,35,45,55,65,70,80,67

// Variables set by HPType
uint8_t RomPage;
uint8_t LibraryPage;
uint16_t RomAddr;
uint16_t MnemonicAddr;  // depends on selected calculator
uint16_t ProgramAddr; // Workspace for programs
uint8_t ProgramPages;
uint8_t RegisterPages; // 1 page = 8 registers

void ReadFlashInfo(uint8_t addr)
{
  SST25Read(FLASHINFOPAGE,FLASHINFO+addr,rombuf8,FPAGESIZE);
}

uint8_t SST25SetRomAddr(uint8_t TypeNr)
{
// read memory organization of Flash
// read where calculator has its firmware, Mnemonics keytables etc. located

  ReadFlashInfo(0);

  if(TypeNr==255 /*|| rombuf8[0]!=0x21*/) // HP-21 must be first entry otherwise data is corrupt // no ROM present
  {
    ProgramPages=1;   // set HP-25, hope no other data is corrupt
    RegisterPages=1;
    RomPage=1;
    LibraryPage=LIBRARYPAGE;
    RomAddr=0x8000;
    ProgramAddr=0x0000;
    MnemonicAddr=0x0000;
    TypeFlags=0xc0;
    return 0x25;   
  }

  uint8_t *pt=rombuf8+TypeNr;
  uint8_t Type=pt[0];

  RomPage=pt[32] & 0x0f;
  LibraryPage=pt[32]>>4;

  ReadFlashInfo(64);

  RomAddr=pt[0]<<8;
  ProgramPages=pt[32]>>4;
  RegisterPages=pt[32] & 0x0f;

  ReadFlashInfo(128);

  ProgramAddr=pt[0]<<8;
  MnemonicAddr=pt[32]<<8;
  
  ReadFlashInfo(192);

  TypeFlags=pt[0];
  
  return Type;
}

#ifdef CONTMEMORY
// write act registers and RAM banks to flash
void WriteContinuousMemory(uint8_t TypeNr)
{
  uint16_t addr,size;

  addr=TypeNr*128; // 128 byte standard RAM

  SST25WriteToPage(CONTEXTPAGE,ACTSTATEADDR+addr,(uint8_t *)ACT_STATE); // write 128 byte context
  SST25WriteToPage(CONTEXTPAGE,ACTSTATEADDR+64+addr,(uint8_t *)ACT_STATE+64);

  size=112; // 16 RAM registers standard
  if(TypeFlags & TF_29_34_67) // HPType==0x29 || HPType==0x34 || HPType==0x67)
  {
    size=448;
    addr=MAXCALCULATORS*128;
    if(HPType==0x34)
      addr+=448;
    if(HPType==0x67)
      addr+=2*448;
  }
  for(uint16_t i=0;i<size;i+=64)
  {
    SST25WriteToPage(CONTEXTPAGE,CONTMEMADDR+addr,(uint8_t *)ACT_RAM+i);
    addr+=64;
  }
}

void ReadContinuousMemory(uint8_t TypeNr)
{
  uint16_t addr,size;
  uint8_t offset=0;

  addr=TypeNr*128; // 128 byte RAM for each calculator

  SST25Read(CONTEXTPAGE,ACTSTATEADDR+addr,(uint8_t *)ACT_STATE,112);  // 112 byte context for each calculator (32+80)

  size=112; // 112 byte RAM
  if(TypeFlags & 8) // HPType==0x29 || HPType==0x34 || HPType==0x67)
  {
    size=448;
    addr=MAXCALCULATORS*128; // behind standard RAM
    if(HPType==0x34)
      addr+=224;
    if(HPType==0x67)
      addr+=2*448;
  }
  if(user_flags1 & UF_KEEPREGISTERS)
  {
    offset=56; // don't read first 8 registers
    size-=56;
  }
  SST25Read(CONTEXTPAGE,CONTMEMADDR + addr+offset,(uint8_t *)ACT_RAM+offset,size); // read size bytes RAM registers
}
#endif

// Init SPI Bus at high speed
void SST25Init()
{
// Init SPI Bus
// SCK, CKP=0, CKE=0, SMP=0
// Bei positiver Flanke SCK wechselt SDO, bei negativer Flanke SCK wird SDI eingelesen.

	SSPCON1=0x00; // SPI master mode, clock FOSC/4=4 MHz SMP=0, CKP=0,  Mode 0 idle low,
	SSPSTAT=0x40; // SMP=0 CKE=1, Data output on falling edge 
	SSPEN=1;      // enable SPI interface
  SST25WriteSR(0x2c); // 1/2 bottom Memory protection (0x3c=full protection)
}

void SST25WriteEnable()
{
  CE2=0;
 	SSPBUF=0x06; while(BF==0);// Write enable Command, BF = Buffer Full Flag in SSPSTAT
  CE2=1;
}

void SST25WriteDisable()
{
  CE2=0;
 	SSPBUF=0x04; while(BF==0);// Write enable Command
  CE2=1;
}

uint8_t SST25ReadSR() // read Status register Busy Flag
{
  CE2=0;
 	SSPBUF=0x05; while(BF==0);// Read Status Register
  SSPBUF=0x00; while(BF==0);
  CE2=1;
  return SSPBUF;
}

// Write SR=0x00 to disable block protection
void SST25WriteSR(uint8_t SR) // write Status register
{

  SST25WriteEnable();
  CE2=0;
 	SSPBUF=0x01; while(BF==0);// Write Status Register
  SSPBUF=SR;    while(BF==0);
  CE2=1;
  while(SST25ReadSR() & 1); // wait until Write cycle is finished
//  SST25WriteDisable(); // WEL will be reset automatically
}


//inline uint8_t SST25Busy() { return SST25ReadSR() & 1; }
// addr bits 23-12 determine 4k Sector, bits 11-0 are not used
void SST25Erase(uint8_t page, uint16_t addr)
{
  SST25WriteEnable();
  uint8_t buf[4];
  buf[0]=0x20; // Erase command 0x20=Erase4k  0xd8=erase64k
  buf[1]=page;
  buf[2]=addr>>8;
  buf[3]=addr;
  CE2=0;
  for(uint8_t i=0;i<4;i++)
  {
 	  SSPBUF=buf[i]; while(BF==0); 
  }
  CE2=1;
  while(SST25ReadSR() & 1); // wait until Write cycle is finished
//  SST25WriteDisable();  // WEL bit will be reset automatically
}

#if 0
void SST25EraseChip()
{
  SST25WriteEnable();
  CE2=0;
  SSPBUF=0x60; while(BF==0); 
  CE2=1;
  while(SST25ReadSR() & 1); // wait until Write cycle is finished
}
#endif

void SST25Read(uint8_t page, uint16_t addr,uint8_t *data, uint8_t length)
{
#ifdef XDEBUG
  for(uint8_t i=0;i<length;i++) data[i]=0;
#else
  CE2=0;
  SSPBUF=0x03;    while(BF==0); // Read Command up to 25MHz at 2.7V, we use 4 MHz
  SSPBUF=page;    while(BF==0);
  SSPBUF=addr>>8; while(BF==0);
  SSPBUF=addr;    while(BF==0);
  
  while(length--)
  {
  	SSPBUF=0;   while(BF==0); // send 0 byte to read data, wait until buffer full
    *data++=SSPBUF;
  }
  CE2=1;
#endif
}

// write page up top 256 byte length 0=256
void SST25Write(uint8_t page, uint16_t addr, uint8_t *data,uint8_t length)
{
  SST25WriteEnable();
  uint8_t buf[4];
  buf[0]=0x02; // Page program
  buf[1]=page;
  buf[2]=addr>>8;
  buf[3]=addr;

  CE2=0;
  for(uint8_t i=0;i<4;i++) // send Byte Write Command and 24-bit address
  {
  	SSPBUF=buf[i]; while(BF==0);
  }
  do // send Byte Write Command and 24-bit address
  {
  	SSPBUF=*data++; while(BF==0);
  } while(--length!=0);
  CE2=1;

  while(SST25ReadSR() & 1); // wait until Write cycle is finished
//  SST25WriteDisable(); // page program completion resets WEL bit automatically
}

#if 0
static uint8_t rombufempty()
{
  for(uint8_t i=0;i<FPAGESIZE;i++)
    if(rombuf8[i]!=0xff)
      return FALSE;
  return TRUE;
}
#endif
// writes 64 byte to addr within a page preserving the 4k data outside the address range
// Because PIC processor doesn't have s 4k RAM buffer and writing to Flash needs to erase a 4k page of memory,
// to preserve the data in the block, the 4k block is copied first to an erased 4k page,
// the new data is modified, then 4k page is copied back to its destination.

// each data write will need to erase 2x4k blocks
// this is necessary because the PIC processor has only limited amount of RAM, we use a 64 byte buffer
// page destination write page
// addr write address, must be multiple of 64 byte
// data Data block to write pointer to RAM data always 64 byte, may point to rombuf, but the contents of rombuf will be destroyed
void SST25WriteToPage(uint8_t page, uint16_t addr, uint8_t *data)
{
uint16_t flashaddr;
uint8_t i;

  SST25Erase(SCRATCHPAGE,0x0000); // erase 4k block scratch area
  SST25Write(SCRATCHPAGE,addr & 0x0FFF,data,FPAGESIZE); // write new data now, this allows to use romdata as argument

// copy 4k page to scratch area and modify data

  flashaddr=addr & 0xF000;  // 4k boundary
  for(i=0;i<64;i++) // 64 pages of 64 bytes is 4k byte
  {
    if(flashaddr!=addr)
    {
      SST25Read(page,flashaddr,rombuf8,FPAGESIZE); // read 64 byte block from flash into rombuf
      SST25Write(SCRATCHPAGE,flashaddr & 0x0FFF,rombuf8,FPAGESIZE);
    }
    flashaddr+=FPAGESIZE;
  }

// now copy 4k scratch area back to desired page

  flashaddr=addr & 0xF000;
  SST25Erase(page,flashaddr);

  for(i=0;i<64;i++) // 64*FPAGESIZE =4096 bytes
  {
    SST25Read(SCRATCHPAGE,flashaddr & 0x0FFF,rombuf8,FPAGESIZE); // read 64 byte block from flash into rombuf
    SST25Write(page,flashaddr,rombuf8,FPAGESIZE);
    flashaddr+=FPAGESIZE;
  }
}  

#ifdef SERIALPORT
// empfngt 64 byte Daten von PC und schreibt sie nach page addr
// der Speicherbereich muss zuvor gelscht worden sein.
void ReceivePCData(uint8_t page, uint16_t addr)
{
  if(ReceiveBytes(rombuf8,FPAGESIZE))
    SST25Write(page,addr,rombuf8,FPAGESIZE);
}

// sendet 64 byte Daten an PC
void SendPCData(uint8_t page, uint16_t addr)
{
  uint8_t i;
  uint8_t *pt=(uint8_t *)rombuf;
  SST25Read(page,addr,(uint8_t *)rombuf,FPAGESIZE);
  for(i=0;i<FPAGESIZE;i++)
    WriteSer(pt[i]);
}

#endif //SERIALPORT
