
#define FPAGESIZE 64  // one page is 64 byte and contains 8 registers of 7 byte or one program of 49 bytes

// Banks 0-3 are write protected
#define KEYCODEPAGE    0  // Keycode Tables
#define QUOTATIONPAGE  0  // Text Quotations 32k
#define FLASHINFOPAGE  0  // FlashInfo/Constants
#define FCNPAGE        0  // Function Offsets
#define ROM1PAGE       1  // ROM code HP01,21,2225,27,29 etc
#define ROM2PAGE       2  // ROM code Spice calculators
#define TEXTPAGE       3  // Text and Mnemonics
#define LIBRARYPAGE    4  // Programs and Registers HP25,29,33
#define LIBRARYPAGE2   5  // Programs Registers HP34,67
#define REGISTERPAGE   6
#define CONTEXTPAGE    6  // Processor Context
#define FCONSTANTPAGE  6  // Constants
#define TICKERTEXTPAGE 6
#define FLASHVARPAGE   6  // Flash Variables
#define SCRATCHPAGE    7

// Bank 0
#define KEYTABLE        0x0000 // 128 byte per calculator 4k
#define PRINTTRACETABLE 0x1000 // 128 byte per calculator 4k 32 calculators
#define TRACETABLE      0x2000 // 128 byte per calculator 4k 
#define KEYSEQUENCE     0x3000 // ca 800 bytes 1 k reserved
#define FLASHINFO       0x4000  // 256 byte 
#define FCNADDR         0x4100 // 512 byte (1 kB) function Offset
#define QUOTATIONADDR   0x8000  // 64 byte TickerText followed by Quotations

// 100 constants each 8 byte = 800 bytes use 1024
// 10*8 oder 10*16 register fr USERREGISTER = 1120 byte 7 byte pro register
// 10*
// 8 x 64 byte Continuous Memory = 512 byte
// 100 programs of 64 byte/128 byte/256 byte = 24*1024 Program area fixed programs and variable program area
// 55 Programme HP-25 Programmsammlung
// 0xFF80 Calculator Flash information 128 byte

// bank 1 Flash addresses in second 64 k address page
#define HP21FROM   0x0000  // 1k 10-bit words = 2kB
#define HP35FROM   0x0800  // 1k 10-bit words = 2kB 768 words
#define HP45FROM   0x1000  // 2k 10-bit words = 4kB
#define HP55FROM   0x2000  // 3k = 6kb
#define HP65FROM   0x3800  // 3k = 6kB
#define HP70FROM   0x5000  // 2k = 4kB
#define HP80FROM   0x6000  // 2k = 4kB 1800 words
#define HP22FROM   0x7000  // 2k = 4kB
#define HP25FROM   0x8000  // 2k 10-bit words = 4kB
#define HP29FROM   0x9000  // 4k = 8kB
#define HP01FROM   0xB000  // 2k = 4kB
#define HP67FROM   0xC000  // 5k = 10kB
#define HP27FROM   0xE800  // 3k = 6kB
// 0 kB free

// bank 2 Flash addresses in third 64 k address page
#define HP31FROM   0x0000  // 2k = 4kB
#define HP32FROM   0x1000  // 4k = 8kB
#define HP33FROM   0x3000  // 4k = 8kB
#define HP34FROM   0x5000  // 8k = 16kB
#define HP38FROM   0x9000  // 8k = 16kB
#define HP37FROM   0xD000  // 3k = 6kB  -E7FF

// bank 3
#define MNEMONICSADDR  0x0000  // 8 x Print Mnemonics und 8 x Display Mnemonics
#define FTEXTADDR      0x7C00  // 1k byte of text
// Print Mnemonics 0x0000, 0x0500, 0x0b00, 0x1100
// Display Mnemonics 0x2000, 0x2500, 0x2b00, 0x3100
// Texte 0x3E00 

// bank 4 SST Flash addresses for programs and registersets
#define HP25PROGRAMS    0x0000  // 12k 110*64= 7040 (0x1B7F)
#define HP25APPPROGRAMS 0x1B80  // up to 82 Application Programs 0x1b80-2FFF
#define HP29PROGRAMS    0x3000  // 16k 110*128 = 14080 (0x3700)
#define HP29APPPROGRAMS 0x6700  // 50 Application Programs 0x6700-0x7FFF
#define HP33PROGRAMS    0x8000  // 8k 110*64= 7040 0x8000-0x9FFF
#define HP38PROGRAMS    0xA000  // 16k 110*128 14080
#define HP55PROGRAMS    0xE000  //
#define HP65PROGRAMS    0xF000  //
// bank 5
#define HP34PROGRAMS 0x0000  // 32k in LIBRARYPAGE2
#define HP67PROGRAMS 0x8000  // 32k


// bank 6 SST Flash addresses for registersets and other writable data
#define STOADDR      0x0000  // store register sets 4k for up to 32 calculators = 32*0x500=40960 =0xA000
#define TICKERTEXTADDR 0xC000
#define ACTSTATEADDR   0xD000
#define CONTMEMADDR    0xE000
#define FLASHVARADDR   0xF000
#define FCONSTADDR   0xFC00  // 100 constants each 8 byte = 800 bytes FC00-FF1F

// Bank 7
#define SCATCHAREA   0x0000 // 4k scratch for write pages


//#define FCONTMEMORY 0x1400 // 8 x 64 byte Continuous Memory = 512 byte
//#define FPRGMADDR  0x1800  // 100 programs of 64 byte/128 byte/256 byte = 24*1024 Program area fixed programs and variable program area
// until end of 64k page = 58k = 232 HP-67 programs = 464 HP-29 programs = 928 HP-25 programs

void SST25Init();
void SST25WriteEnable();
void SST25WriteDisable();
uint8_t SST25ReadSR();
void SST25WriteSR(uint8_t SR);
void SST25Erase(uint8_t page, uint16_t addr);
void SST25EraseChip();
void SST25Read(uint8_t page, uint16_t addr,uint8_t *data, uint8_t length);
void SST25Write(uint8_t page, uint16_t addr, uint8_t *data, uint8_t length);
void SST25WriteByte(uint8_t page, uint16_t addr, uint8_t data);
void SST25WriteToPage(uint8_t page, uint16_t addr, uint8_t *data);
uint8_t SST25SetRomAddr(uint8_t TypeNr);
void ReadFlashInfo(uint8_t addr);

void ReceivePCData(uint8_t page, uint16_t addr);
void SendPCData(uint8_t page, uint16_t addr);
void SendRAMData(uint16_t addr,uint8_t size);
void WriteContinuousMemory(uint8_t TypeNr);
void ReadContinuousMemory(uint8_t TypeNr);

extern uint8_t RomPage;
extern uint8_t LibraryPage;
extern uint16_t RomAddr;
extern uint16_t MnemonicAddr;
extern uint16_t ProgramAddr;
extern uint8_t ProgramPages;
extern uint8_t RegisterPages;
