#include "hp25lp.h"
#include "undo.h"
#include "program.h"
#include "act.h"
#include "string.h"

#ifdef UNDO

static uint8_t undostep;
static uint8_t undocode;

creg_t undo_stack[4] @ 0x3A0; // 28 byte undo stack in upper RAM pages because only used by HP25/29

void SaveProgramStep()
{
	undostep=GetProgramStep()+1; // HP-25 BCD 2-digit program step is coded in m
  uint8_t i=ProgramIndex(undostep);
  uint8_t *pt=(uint8_t *)ACT_RAM+9*7; // point to HP-25 program area
  undocode=pt[i];
}

void UndoProgramStep()
{
  uint8_t i=ProgramIndex(undostep);
  uint8_t *pt=(uint8_t *)ACT_RAM+9*7; // point to HP-25 program area
  pt[i]=undocode;
}

void SaveStack()
{
  first=0;last=4*WSIZE/2; // copy 4 registers y,z,t,n
  src=(uint8_t *)ACT_REGS+3*WSIZE; // start with act_y via linar memory pointer
  dest=(uint8_t *)undo_stack;
  reg_copy();
#if 0
  memcpy(undo_stack, ACT_REGS+3*WSIZE,4*WSIZE/2); // bersetzt falsch
	for(uint8_t i=0;i<WSIZE/2;i++)
	{
		undo_stack[0][i]=act_n[i];
		undo_stack[1][i]=act_y[i];
		undo_stack[2][i]=act_z[i];
		undo_stack[3][i]=act_t[i];
	}
#endif
}

void UndoStack()
{
	uint8_t i;

  first=0;last=4*WSIZE/2;
  dest=(uint8_t *)ACT_REGS+3*WSIZE;
  src=(uint8_t *)undo_stack;
  reg_copy();
#if 0
  memcpy(ACT_REGS+3*WSIZE,undo_stack,4*WSIZE/2);// compiler bersetzt falsch statt 0x20A7  0xA0A7
	for(i=0;i<WSIZE/2;i++)
	{
		act_n[i]=undo_stack[0][i];
		act_y[i]=undo_stack[1][i];
		act_z[i]=undo_stack[2][i];
		act_t[i]=undo_stack[3][i];
	}
#endif
}

#endif

