#include "xc.h"
#include "act.h"
#include "version.h"

// act emulator opcode instruction routines
// not yet compatible with voyager act
// voyager needs adaption to reg_test_ functions
// _op_keys_to_a:
// _op_a_to_rom_addr:
// _op_gokeys: must call CheckAddress external compiler problem
// speed and size optimized assembler routines for ACT arithmetic core

// Bernhard Emese PANAMATIK (c) 2017

// op6 must be set before calling functions that use it op6=opcode>>6
// opcode may not be changed except according to dedicated instructions

// all routines rely on following variables being located in bank 0:
// first, last, src, src2, dest, act_flags, crc_flags, opcode, base, act_p, act_sp
// act_pc, act_flags, act_stack, act_s, act_del_rom
// act_inst_state, act_ram_addr, act_key_buf, hp01flags,


// all calling routines must assume, that following variabes  may be modified:
// _src, _dest, _first, _last

// (all routines assume, that bank 0 is already selected on entry)
// all routines assume, that FSR0 and FSR1 can be used without saving and restoring
// all routines assume, that all indexed _src and _dest locations dont overflow into the next bank
// _first and _last must be in range from 0 to 79  

// conventions:
// src pointer uses FSR0 , dest pointer uses FSR1

#ifdef USEASM

#asm
; asm code located at fixed adresses
  psect	asmarea,global, abs, ovrld,class=CODE,merge=1,delta=2

	ORG 0x1000

; QC passed 30.10.2017
_op_binary:
	movlw	16
	goto	l_101
; QC passed 30.10.2017
_op_decimal:
	movlw	10
l_101:
  movlb  0
	movwf	_base

_op_unknown:
_op_nop:
_op_display_reset_twf:
_op_rom_addr_to_buf:
_op_crc_test_motor_on:
_op_crc_test_card_in:
_op_crc_write_prot:
_op_crc_motor_on:
_op_crc_motor_off:
_op_crc_test_prot:
_op_pik_home:
_op_pik_cr:
_op_pik_keys:
_op_pik_print3:
_op_pik_print6:
	return

_op_crc_set_f0:
  movlb   0
	bsf    _crc_flags,0   ; crc_flags |=1<<0;
	return

_op_crc_set_f1:
  movlb   0
	bsf    _crc_flags,1   ; crc_flags |=1<<1;
	return

_op_crc_set_f2:
  movlb   0
	bsf    _crc_flags,2   ; crc_flags |=1<<2;
	return

_op_crc_set_f3:
  movlb   0
	bsf    _crc_flags,3   ; crc_flags |=1<<3;
	return

_op_crc_set_f4:
  movlb   0
	bsf    _crc_flags,4   ; crc_flags |=1<<4;
	return

_op_crc_clear_f0:
  movlb   0
  btfsc  _crc_flags,0    ; if(crc_flags & 1)
  bsf    _act_s,3       ;   act_s|=1<<3;
	bcf    _crc_flags,0   ; crc_flags &=~(1<<0);
	return

_op_crc_clear_f1:
  movlb   0
  btfsc  _crc_flags,1   ; if(crc_flags & 2)  // test Pause pending
  bsf    _act_s,3       ;   act_s|=1<<3;
	bcf    _crc_flags,1   ; crc_flags &=~(1<<1);
	return

_op_crc_test_f1:
  movlb   0
  btfss    _act_flags,0     ;  if(!(act_flags & AF_RUNMODE))
  bsf      _act_s,3         ;  act_s|=1<<3;
  bcf      _crc_flags,1     ; crc_flags &=~(1<<1);
  return

_op_crc_test_f2:
  movlw   4
  goto    crc_test_f

_op_crc_test_f3:
  movlw   8
  goto    crc_test_f

_op_crc_test_f4:
  movlw   16

; void crc_test_f(uint8_t mask) // mask entweder 1 2 4 8
crc_test_f:
  movlb   0
  movwf  _dest
  bcf    _crc_flags,7   ; crc_flags &= ~0x80;
  btfsc  _act_s,3       ; if(act_s & 1<<3)
  bcf    _crc_flags,7   ; crc_flags|=0x80; // set delayed flag if s3 is set
  bcf    _act_s,3       ; act_s&=~(1<<3);  // reset s3
  andwf  _crc_flags,w   ; if(crc_flags & mask) 
  btfsc  3,2
;  btfsc  _crc_flags,mask   
  bsf    _act_s,3       ; act_s |= 1<<3;
  movf   _dest,w
  xorlw  255
  andwf  _crc_flags
  movwf   _dest
;  bcf    _crc_flags,mask     ; crc_flags &= ~mask;
  btfsc   _crc_flags,7   ;  if(crc_flags & 0x80)
  iorwf   _crc_flags
;  bsf    _crc_flags,mask  ; crc_flags |= mask;  // set f2 if delayed flag is set
	return

; QC passed 29.10.2017
_op_bank_switch:
  movlb   0
  movlw   80h
	xorwf   _act_flags     ; act_flags ^= AF_BANK;
  return

; QC passed 29.10.2017
_op_set_s:
  movlb  0
	movlw	 1
	movwf	_dest       ; 1<<n  n=0-15
	clrf	_dest+1

	incf	_op6,w
	goto	l_131
l_130:
	lslf	_dest       ; shift left bitmask by op6 bits
	rlf		_dest+1
l_131:
	decfsz	9,f
	goto	l_130
	movf	_dest,w
	iorwf	_act_s,f
	movf	_dest+1,w
	iorwf	_act_s+1,f
	return

; QC passed 29.10.2017
_op_clr_s:
	call	_op_set_s
	comf	_dest,w
	andwf	_act_s,f
	comf	_dest+1,w
	andwf	_act_s+1,f
	return

// clear act_a,b,c,y,z,t, don't clear m,n
; QC passed 30.10.2017
_op_clear_reg:
  movlb  0
	clrf	_first
	movlw	 62  ; 3*14 + 3*7 = 63 byte
	movwf	_last
	movlw	low _act_a
	movwf	_dest
	movlw	high _act_a
	movwf	_dest+1
	call	_reg_zero
	return

_op_clear_s_classic:
  movlb   0
  clrf   _act_s    ; act_s = 0; // clear all bits
  return

; QC passed 29.10.2017
_op_clear_s:
  movlb   0
  movlw   80h     ;	act_s&=0x8026; // clear all bits except 1,2,5,15
  andwf   _act_s+1
  movlw   26h
  andwf   _act_s
  return

; QC passed 30.10.2017
_op_display_toggle:
  movlb   0
  movlw  32
  xorwf  _act_flags         ;	act_flags ^= AF_DISPLAY_ON;
  return

; QC passed 30.10.2017
_op_display_off:
  movlb   0
	bcf   _act_flags,5       ; act_flags  &= ~AF_DISPLAY_ON;
  bcf   _hp01flags,1       ; hp01flags &= ~F_BLINK;
  return

_op_m_exch_c:
  movlb   0
  bcf   _dest,6   ; force exch instruction
  goto l_127
_op_m_to_c:
  movlb   0
  bsf   _dest,6   ; force copy instruction
l_127:
	movlw	low _act_m
	movwf	FSR1L
	movlw	high _act_m
	movwf	FSR1H
  goto  op_mx1

; op_m_exch_c, op_m_to_c, op_n_exch_c, op_n_to_c

; QC passed 29.10.2017
_op_mx:
  movlb  0
	movf  _opcode,w   ; dest = opcode
  movwf _dest

	movlw	low _act_m
	btfsc	_opcode,7
	movlw	low	_act_n
	movwf	FSR1L
	movlw	high _act_m
	btfsc	_opcode,7
	movlw	high _act_n
	movwf	FSR1H
op_mx1:	
	movlw	low _act_c
	movwf	FSR0L
	movlw	high _act_c
	movwf	FSR0H
	
	movlw	7
	movwf	_first
	
l_151:

;	incf	FSR0
;	swapf	INDF0,w
	moviw	[1]FSR0  ; act_c[i+1]<<4
	swapf	WREG,w
;	decf	FSR0
	iorwf	INDF0,w ; act_c[] has only values from 0-f
	movwf	_last
	
	movf	INDF1,w ; act_c[i] = pt[j]&0x0f;
	andlw	15
	movwf	INDF0	
	incf	FSR0L
	
	swapf	INDF1,w ; act_c[i+1] = pt[j]>>4;
	andlw	15
	movwf	INDF0	
	incf	FSR0L
	
	btfsc	_dest,6 ; if (!((char)opcode & (1<<6)))
	goto l_150
	
	movf	_last,w ; pt[j] = t;
	movwf	INDF1
	
l_150:
	incf	FSR1L
	decfsz	_first
	goto  l_151
	return

; QC passed 30.10.2017
_op_stack_to_a:
	call	_op_y_to_a

	movlw	high _act_y			; all act_registers a,b,c,y,z,t are located in bank 1
	movwf	FSR0H
	movwf	FSR1H
	movlw	low _act_z
	movwf	FSR0L
	movlw	low _act_y
	movwf	FSR1L
	movlw	14              ; copy 14 bytes
  movwf _first
l_174:
	moviw	FSR0++
	movwi	FSR1++	; act[y[i] = act_z[i]
  decf  _first
	skipz
	goto l_174
	return

; QC passed 30.10.2017
_op_y_to_a:

  movlb  0
	movlw	7  ; WSIZE/2
	movwf	_first

	movlw	low _act_a;
	movwf	FSR1L
	movlw	high _act_a
	movwf	FSR1H
	
	movlw	low _act_y
	movwf	FSR0L
	movlw	high _act_y
	movwf	FSR0H

l_170:
	movf	INDF0,w
	andlw	15
	movwi	FSR1++
	swapf	INDF0,w
	andlw	15
  movwi FSR1++
	moviw FSR0++
	decfsz	_first
	goto l_170	
	return

; QC passed 30.10.2017
_op_down_rotate:
  movlb 0
	movlw	high _act_c			; all act_registers a,b,c,y,z,t are located in same bank
	movwf	FSR0H
	movwf	FSR1H
	movlw	low _act_c
	movwf	_dest
	movlw	low _act_y
	movwf	_src

l_176:
  movf  _dest,w
	movwf FSR0L
	moviw FSR0++  ; act_c[i*2]
	andlw	15
	movwf	_s2
	swapf	INDF0,w ; act_c[i*2+1]<<4
	andlw	240
	iorwf	_s2		; temp = act_c[i*2] & 0x0f | act_c[i*2+1]<<4
  incf  _dest
  incf  _dest

	movf	_src,w  ; act_y
	movwf	FSR1L
	swapf	INDF1,w
	andlw	15
	movwi	FSR0--		; act_c [i*2+1] = act_y[i]>>4;
	movf	INDF1,w
	andlw 15
	movwf	INDF0		; act_c [i*2] = act_y[i]&0x0f;

	movf	_src,w
	addlw	7
	movwf	FSR0L  ; act_z
	movf	INDF0,w
	movwf	INDF1  ; act_y [i] = act_z [i];

	movlw	14
	addwf	FSR1L	; act_t
	movf	INDF1,w
	movwf	INDF0  ; act_z [i] = act_t [i];

	movf	_s2,w
	movwf	INDF1  ; act_t [i] = temp;

	incf	_src
	movlw	low _act_z  ; 74+7
	subwf	_src,w
	skipz
	goto l_176
	return

; QC passed 30.10.2017
_op_c_to_stack:
  movlb 0
	movlw	low _act_t
	movwf	_first
	movlw	low _act_c
	movwf	_last

	movlw high _act_c		; all act_registers a,b,c,y,z,t are located in bank 1
	movwf	FSR0H
	movwf	FSR1H
l_172:
	movf	_first,w	; act_t
	movwf	FSR0L
	movwf	FSR1L
	movlw	7
	subwf	FSR0L  ; act_z
	movf	INDF0,w
	movwf	INDF1		; act_t[i]=act_z[i]	
	movlw	14
	subwf	FSR1L ; act_y
	movf	INDF1,w
	movwf	INDF0  ; act_z[i]=act_y[i]

	movf	_last,w
	movwf	FSR0L	; act_c
	moviw	FSR0++
	andlw	15
	movwf	INDF1
	swapf	INDF0,w
	andlw	240
	iorwf	INDF1  ; act[y[i] = act_c[i*2]& 0x0f | act_c[i*2+1]<<4
	incf	_last
	incf	_last

	incf	_first
	movlw	 low (_act_t+7)
	subwf	_first,w
	btfss	3,0
	goto l_172
	return

; QC passed 29.10.2017
_op_f_to_a:
  movlb   0
  movf   _act_f,w
  BANKSEL (_act_a)
  movwf  BANKMASK(_act_a)         ; act_a [0] = act_f;
  return

; QC passed 29.10.2017
_op_f_exch_a:
  BANKSEL (_act_a)
  movf   BANKMASK(_act_a),w 	      ; uint8_t t = act_a [0];
  movlb   0
  movwf  _dest
  movf   _act_f,w
  BANKSEL (_act_a)
  movwf  BANKMASK(_act_a)         ; act_a [0] = act_f;
  movlb   0
  movf   _dest,w
  movwf  _act_f         ;	act_f = t;
  return

; QC passed 30.10.2017
_op_circulate_a_left:
  movlb  0
	movlw	low _act_a
	movwf	FSR0L
	movlw	high _act_a
	movwf	FSR0H
	movlw	13
	movwf	_first
	moviw	[13]FSR0
	movwf	_last
l_126:
	moviw	[12]FSR0
	movwi	[13]FSR0
	decf	FSR0L

	decfsz	_first
	goto	l_126
	movf	_last,w
	movwi	[13]FSR0
	return

; QC passed 30.10.2017
_op_dec_p_classic:
  movlw 16
  goto dec_p
_op_dec_p:	
	movlw	14
dec_p:
  movlb  0
	movf	_act_p,f ; test zero
	skipnz
	movwf	_act_p ; act_p = WSIZE;
	decf	_act_p ; act_p--;
	return

; QC passed 30.10.2017
_op_inc_p_classic:
  movlw  16
  goto  inc_p
_op_inc_p:
	movlw	14
inc_p:
  movlb  0
	incf	_act_p ; act_p++;
	subwf	_act_p,w ; if (act_p >= 14)
	skipc
	return
	clrf	_act_p ; act_p = 0;
	bsf		_act_flags,6 ; act_flags|=(1<<6); // PCARRY
	return

; QC passed 29.10.2017
_handle_del_rom:
  movlb  0
	btfss	_act_flags,3
	return
	movf	_act_del_rom,w
	movwf	_act_pc+1
	bcf		_act_flags,3
	return

; QC passed 30.10.2017
_op_gokeys:
  movlb   0
  clrf    _act_pc     ; act_pc &= 0xFF00;
	call   _handle_del_rom
  movf   _act_key_buf,w
  movwf  _act_pc     ; act_pc |= act_key_buf;
  return

; QC passed 30.10.2017
_op_keys_to_a:
  movlb 0
  movf  _act_key_buf,w
  BANKSEL(_act_a)
  movwf  BANKMASK(_act_a+1)
  movwf  BANKMASK(_act_a+2)
  swapf  BANKMASK(_act_a+2)
  movlw  15
  andwf  BANKMASK(_act_a+1)
  andwf  BANKMASK(_act_a+2)
  return

; QC passed 30.10.2017
_op_a_to_rom_addr:
	call	_handle_del_rom
	movlw	low	(_act_a+2)
	movwf	FSR0L
	movlw	high _act_a
	movwf	FSR0H
	swapf	INDF0,w
	decf	FSR0L
	iorwf	INDF0,w
	movwf	_act_pc
	return

_op_test_s_eq_0:
  movlb  0
	movlw	1
	movwf	_act_inst_state ; act_inst_state = branch;

	movwf	_dest       ; 1<<n  n=0-15
	clrf	_dest+1

	bcf		_act_flags,1 ; act_flags &= ~AF_CARRY;

	incf	_op6,w ; if (act_s & (1<<(opcode >> 6)))
	goto	l_129
l_128:
	lslf	_dest
	rlf		_dest+1
l_129:
	decfsz	9,f
	goto	l_128
	movf	_dest,w
	andwf	_act_s,w
	skipz
	bsf		_act_flags,1 ; act_flags |= AF_CARRY;
	movf	_dest+1,w
	andwf	_act_s+1,w
	skipz
	bsf		_act_flags,1 ; act_flags |= AF_CARRY;
	return

_op_test_s_eq_1:
	call	_op_test_s_eq_0
	movlw	2
	xorwf	_act_flags,f
	return

_op_load_constant_classic:
  movf    _op6,w
  movwf   _dest         ;  if (act_p < WSIZE && op6 < 10)
  movlw   10
  subwf   _dest
  btfsc   3,0
  goto    _op_dec_p_classic
  movlw   14
  subwf   _act_p
  btfsc   3,0
  goto    _op_dec_p_classic

; QC passed 29.10.2017
_op_load_constant:
  movlb  0
	movf	_act_p,w
	addlw	low _act_c
	movwf	FSR1L
	movlw	high _act_c
	movwf	FSR1H
  movf  _op6,w
	movwf	INDF1 ; act_c [act_p] = opcode >> 6;
  goto  _op_dec_p

; QC passed 30.10.2017
; dest 0x20A0+addr*7  w=addr 0-63
_getrampt:
	movlb  0
	movwf  _dest   ; dest=addr
  clrf   _dest+1,f
	lslf	 _dest,f   ; dest = addr*8
	rlf	   _dest+1,f
	lslf	 _dest,f
	rlf	   _dest+1,f
	lslf	 _dest,f
	rlf	   _dest+1,f
	subwf  _dest,f   ; dest-=addr  -> dest=addr*7
  skipc
  decf   _dest+1,f

  movlw	  160     ; dest+=0x20A0
  addwf	 _dest,f
  movlw   32
  addwfc _dest+1,f
  return

_op_sel_rom_classic:
  movlb  0
  movlw  0f8h
  andwf  _act_del_rom ; keep group bit 3
	lslf	 _opcode+1,w  ; act_pc = (opcode & 0x03c0)<<2 | (char)act_pc;
  btfsc  _opcode,7
  bsf    9,0
  iorwf  _act_del_rom,w ; set 3 rom bits
  movwf  _act_del_rom
	movwf	 _act_pc+1
	return

; QC passed 30.10.2017
_op_sel_rom:
  movlb  0
	movf	_opcode+1,w ; act_pc = (opcode & 0x03c0)<<2 | (char)act_pc;
	movwf	_act_pc+1
	movf	_opcode,w
	lslf	9,w
	rlf		_act_pc+1
	lslf	9,w
	rlf		_act_pc+1
	return

_op_c_to_register:
  movlb   0
  movlw   0F0h
  andwf   _act_ram_addr   ; act_ram_addr &= 0xF0;
  movf    _op6,w
  iorwf   _act_ram_addr   ; act_ram_addr |= op6;
; goto    _op_c_to_data

_op_c_to_data:
  movlb   0
  movf    _act_ram_addr,w     ;	c_to_register(act_ram_addr);
; goto    _c_to_register

_c_to_register:
  movlb   0
  movwf    _dest
  movlw   63
  subwf   _dest,w
  skipc              ;	if(addr>=0x40) return // limit to 64 registers
	return
  movf    _dest,w
  call    _getrampt  ; getrampt(addr); result in dest	
	movlw   low _act_c
  movwf   _src
  movlw   high _act_c
  movwf   _src+1		 ; src=act_c; 
	goto   	_reg_compress

; QC passed 29.10.2017
_op_c_to_addr:
  BANKSEL (_act_c)
  swapf  BANKMASK(_act_c+1),w
  iorwf  BANKMASK(_act_c),w   ; assumes, that act_c never uses upper nibble
  movlb   0
  movwf  _act_ram_addr   ; act_ram_addr = (act_c [1] << 4) + act_c [0];
  return

; QC passed 29.10.2017
; load 16-bit pointers FSR0 = _src+first and FSR1 = _dest+first
loadFSR0:
  movlb  0
	movf	_src,w
	addwf	_first,w ; cannot overflow, because no act registers and first 8 RAM registers crosses boundary 
	movwf	FSR0L
	movf	_src+1,w
	movwf	FSR0H

; load 16-bit pointer FSR1 = _dest+first
loadFSR1:
  movlb  0
	movf	_dest,w
	addwf	_first,w  ; cannot overflow, because no act registers  and first 8 RAM registers crosses boundary 
	movwf	FSR1L
	movf	_dest+1,w
	movwf	FSR1H
	return

; QC passed 29.10.2017
_reg_zero:
	call	loadFSR1   ; FSR1 = dest+first

l_100:
	movf	_first,w
	subwf	_last,w
	skipc          ; return if first>last
	return

	movlw	0        ; *dest++=0
  movwi FSR1++
	incf	_first,f
	goto	l_100

; QC passed 29.10.2017
; dest = src;
_reg_copy:
	call	loadFSR0   ; FSR0 = src+first,  FSR1 = dest+first

l_102:
	movf	_first,w
	subwf	_last,w
	btfss	3,0
	return

	moviw	FSR0++    ; *dest++=*scr++
	movwi	FSR1++
	incf	_first,f
	goto	l_102


; QC passed 29.10.2017
; src <-> dest;
_reg_exch:
	call	loadFSR0

l_104:
	movf	_first,w
	subwf	_last,w
	btfss	3,0
	return

	movf	INDF0,w
	movwf	_dest  ; use dest as temp variable
	movf	INDF1,w
	movwf	INDF0
	movf	_dest,w
	movwf	INDF1

	incf    FSR0L,f
	incf    FSR1L,f
	incf	_first,f
	goto	l_104

; QC passed 29.10.2017
;  dst = dest >> one digit, last digit = 0
;  assert first<=last at entry
_reg_shift_right:
	call	loadFSR1

l_106:
	movlw	0
	movwi	[0]FSR1  ; last byte set to 0

	movf	_first,w
	subwf	_last,w
	btfsc	3,2      ; return if first==last
	return

	moviw	[1]FSR1
	movwi	[0]FSR1

	incf    FSR1L,f
	incf	_first,f
	goto	l_106

; QC passed 29.10.2017
; dest = dest << one digit, first digit=0
_reg_shift_left:
  movlb  0
	movf	_dest,w
	addwf	_last,w
	movwf	FSR1L
	movf	_dest+1,w
	movwf	FSR1H

l_108:
	movlw	0
	movwi	[0]FSR1  ; last byte set to 0

	movf	_first,w
	subwf	_last,w
	btfsc	3,2      ; return if first==last
	return

	moviw	[-1]FSR1
	movwi	[0]FSR1

	decf    FSR1L,f
	decf	_last,f
	goto	l_108


; void register_to_c(uint8_t addr)  addr argument is in dest
_register_to_c:
  movlb   0
  movf    _dest,w
  movlw   63
  subwf   _dest,w
  btfss    3,0      ;	if(addr>=0x40) return // limit to 64 registers
	return
  movf    _dest,w
  call    _getrampt  ; getrampt(addr);	
  movf    _dest,w      ; src=dest;
  movwf   _src
  movf    _dest+1,w
  movwf   _src+1
	movlw   low _act_c
  movwf   _dest
  movlw   high _act_c
  movwf   _dest+1		 ; dest=act_c; 
	call   	_reg_decompress
	return

_reg_compress:
  movlb  0
	clrf	_first
	call	loadFSR0

	movlw	7  ; for (uint8_t i=0;i<WSIZE/2;i++)
	movwf	_dest

l_120:
	moviw	FSR0++ ; dest[i] = src[i*2] & 0x0f | src[i*2+1]<<4 ;
	andlw	15
	movwf	_src      ; temporary reg
	swapf	INDF0,w
	andlw	240
	iorwf	_src,w
  movwi FSR1++
  moviw FSR0++  // just increment w not used
	decfsz	_dest
	goto 	l_120
	return

_reg_decompress:
  movlb  0
	clrf	_first
	call	loadFSR0

	movlw	7  ; for (uint8_t i=0;i<WSIZE/2;i++)
	movwf	_dest

l_122:
	moviw	[0]FSR0    ; dest[i*2]   = src[i] & 0x0F;
	andlw	15
	movwi	FSR1++  ; dest[i*2+1] = src[i] >>4;
	swapf	INDF0,w
	andlw	15
	movwi	FSR1++
	moviw	FSR0++  ; increment w not used
	
	decfsz	_dest
	goto 	l_122
	return

_op_return:
  movlb  0
	decf	_act_sp       ; act_sp = (act_sp-1) & (STACKSIZE - 1);
	lslf	_act_sp,w     ; act_pc = act_stack [act_sp];
	andlw	2             ; act_sp & (STACKSIZE-1) ; assume STACKSIZE 2 
	addlw	low _act_stack
	movwf	FSR1L
	movlw	high _act_stack
	movwf	FSR1H
	moviw	[0]FSR1
	movwf	_act_pc
	moviw	[1]FSR1
	movwf	_act_pc+1
	return

_op_c_to_addr_classic:
  BANKSEL (_act_c)
  movf    BANKMASK(_act_c+12),w
  movlb   0
  movwf  _act_ram_addr    ; act_ram_addr = (uint8_t)(act_c[12]); // HP-45, HP-80
  return

_op_c_to_addr_hp55:
  BANKSEL (_act_c)
  lslf    BANKMASK(_act_c+12),w
  lslf    9,w
  lslf    9,w
  addwf   BANKMASK(_act_c+12),w
  addwf   BANKMASK(_act_c+12),w
  addwf   BANKMASK(_act_c+11),w
  movlb   0
  movwf  _act_ram_addr    ; act_ram_addr = (uint8_t)(act_c[12] * 10 + act_c[11]);  // HP-55
  return

; QC passed 29.10.2017
; dest = dest +1; src=NULL
_reg_inc:
  movlb  0
	clrf	_src
	clrf	_src+1
	bsf		_act_flags,1 ; set carry
	
; dest = dest + src + carry

_reg_add:
	call	loadFSR0

l_110:
	movf	_first,w
	subwf	_last,w
	btfss	3,0
	return

	movf	_src,w  ; if (src==NULL)
	iorwf	_src+1,w
	skipz
	movf	INDF0,w
	addwf INDF1,f  ; dest = dest + src
	btfsc	_act_flags,1 ; act carry set ?
	incf	INDF1

	bcf		_act_flags,1
	movf	_base,w
	subwf	INDF1,w
	skipc
	goto l_111

	movwf	INDF1    ; dest = dest - base
	bsf		_act_flags,1
	
l_111:

	incf	FSR0L,f
	incf  FSR1L,f
	incf	_first,f
	goto	l_110

; dest = src - src2 - carry
_reg_sub:

  movlb  0
	movf	_src,w                          
	addwf	_first,w
	movwf	FSR0L
	movf	_src+1,w
	movwf	FSR0H
	iorwf	_src

l_114:

	movf	_src2,w
	addwf	_first,w
	movwf	FSR1L
	movf	_src2+1,w
	movwf	FSR1H
	iorwf	_src2,w
	movwf	_s2

	movf	_first,w
	subwf	_last,w
	btfss	3,0
	return

	movlw	0
	movf	_src,f     ; if(src==NULL)
	skipz
	movwf  	INDF0,w  ; w = src - src2 - carry
	movwf	_src+1
	
	movlw	0
	movf	_s2,f     ; if(src2==NULL)
	skipz
	movf	INDF1,w
	subwf	_src+1,w   ; -s2

	
	btfsc	_act_flags,1 ; act carry set ?
	decf	WREG,w
	bcf		_act_flags,1
	btfss	WREG,7  ; d <0 ?
	goto	l_115
	
	addwf	_base,w  ; w = w + base
	bsf		_act_flags,1

l_115:
	movwf	_src+1   ; src+1 = w

	movf	_dest,w
	iorwf	_dest+1,w
	skipnz
	goto l_117

	movf	_dest,w
	addwf	_first,w
	movwf	FSR1L
	movf	_dest+1,w
	movwf	FSR1H
	movf	_src+1,w
	movwf	INDF1   ; if(dest) dest = w

l_117:
	incf	FSR0L,f
	incf	_first,f
	goto	l_114

; dest = 0;  clear destination
_reg_test_equal:
	call	loadFSR0

	bsf		_act_flags,1
l_116:
	movf	_first,w
	subwf	_last,w
	btfss	3,0
	return
	
	movf	INDF0,w
	incf	FSR0L
	incf	_first
	xorlw	0
	btfsc	3,2
	goto	l_116
	bcf		_act_flags,1
	return

_reg_test_nonequal:
	call	loadFSR0

l_118:
	movf	_first,w
	subwf	_last,w
	btfss	3,0
	return
	
	movf	INDF0,w
	incf	FSR0L
	incf	_first
	xorlw	0
	btfsc	3,2
	goto	l_118
	bsf		_act_flags,1
	return

; QC passed 29.10.2017
_setfield:
  movlb  0
  movwf  _first
  movlw  13    ; most used WSIZE-1
  movwf _last
  movf  _first,f
	skipz
	goto setfield1

setfield0:				; if(field==0)
	movf	_act_p,w	; /* p  */ first = act_p; last = act_p;
	movwf	_first
  goto setlast

setfield1:				
	decfsz	_first
	goto	setfield2	; if(field==1)
	movf	_act_p,w	; /* wp */ first = 0; last = act_p;
  goto setlast

setfield2:
	decfsz	_first
	goto	setfield3	; if(field==2)
	movlw	2			;  /* xs */ first = EXPSIZE - 1; last = EXPSIZE - 1; 
	movwf	_first
  goto  setlast

; QC passed 29.10.2017
setfield3:
	decfsz	_first
	goto	setfield4	; if(field==3)
	movlw	2			; /* x  */  first = 0; last = EXPSIZE - 1;
setlast:
	movwf	_last
	return

setfield4:
	decfsz	_first
	goto	setfield5	; if(field==4)
	movlw	13			; /* s  */  first = WSIZE - 1;   last = WSIZE - 1;
	movwf	_first
	return

setfield5:
	decfsz	_first
	goto	setfield6	; if(field==5)
	movlw	3			; /* m  */  first = EXPSIZE; last = WSIZE - 2;
	movwf	_first
	decf	_last
	return

setfield6:
	decfsz	_first
	goto	setfield7	; if(field==6)
	return		; /* w  */  first = 0; last = WSIZE - 1;

setfield7:				; if(field==7)
	movlw	3			;  /* ms */  first = EXPSIZE; last = WSIZE - 1; 
	movwf	_first
	return

; QC passed 29.10.2017
_op_jsb:
  movlb  0
	lslf	_act_sp,w ; act_stack [act_sp] = act_pc;
	andlw	2 ; act_sp & (STACKSIZE-1) ; assume STACKSIZE 2
	addlw	low _act_stack
	movwf	FSR1L
  movlw high _act_stack
	movwf	FSR1H
	movf	_act_pc,w
	movwi	[0]FSR1
	movf	_act_pc+1,w
	movwi	[1]FSR1
	incf	_act_sp ; act_sp = (act_sp+1) & (STACKSIZE-1);  STACKSIZE = 2
	goto 	op_goto1 ; act_pc = (act_pc & 0xFF00) | (opcode >> 2);  handle_del_rom();

; QC passed 29.10.2017
_op_goto_classic:
  movlb  0
  bsf    _act_flags,3  ; set DEL_ROM flag always
; QC passed 29.10.2017
_op_goto:
  movlb  0
	btfsc	_act_flags,2 ; 	if (!(act_flags & AF_PREV_CARRY))
	return
op_goto1:
	movf	_opcode,w ; act_pc = (act_pc & 0xFF00) | (opcode >> 2);
	movwf	_act_pc
	lsrf	_opcode+1,w
	rrf		_act_pc
	lsrf	9,w
	rrf		_act_pc
  call  _handle_del_rom
  return

_op_set_p_classic:
  movf		_op6,w
  movwf   _act_p   ; act_p = op6;
  return

; QC passed 29.10.2017
_op_set_p:
  movf     _op6,w
  addlw    low (_p_set_map | 32768)
  movwf    FSR0L
  movlw    high (_p_set_map | 32768)
  skipnc
  addlw    1
  movwf    FSR0H
  movf     INDF0,w
  movwf    _act_p    ;	  act_p = p_set_map [op6];
  return

; QC passed 29.10.2017
gettestmap:
  movf     _op6,w
  addlw    low (_p_test_map | 32768)
  movwf    FSR0L
  movlw    high (_p_test_map | 32768)
  skipnc
  addlw    1
  movwf    FSR0H
  movf     INDF0,w
  return

; QC passsed 29.10.2017
_op_test_p_eq:
  movlb   0
  movlw   1
  movwf   _act_inst_state  ;	act_inst_state = branch;
	bsf     _act_flags,1   ; act_flags |= AF_CARRY;
  call    gettestmap
  subwf   _act_p,w     ; if (act_p == p_test_map [op6])
  skipnz
	bcf     _act_flags,1   ; act_flags &=~AF_CARRY;
  return

_op_test_p_ne:
  movlb   0
  movlw   1
  movwf   _act_inst_state  ;	act_inst_state = branch;
  call    gettestmap
  subwf    _act_p,w     ; if (act_p == p_test_map [op6])
  skipnz
	bsf     _act_flags,1   ; act_flags |=AF_CARRY;
  return

//not tested
_op_test_p_ne29:
  call    _op_test_p_ne
  btfss   _act_flags,1    ; if(act_flags & AF_PCARRY && act_p==1 && n==0)
  return
  movlw   1
  subwf    _act_p,w
  btfss   3,2
  return
  call    gettestmap
  btfsc   3,2
	bsf     _act_flags,1   ; act_flags |=AF_CARRY;
  return

; QC passed 29.10.2017
_op_del_sel_rom:
  movlb  0
	movf	_opcode+1,w ;	act_del_rom = opcode >> 6;  // result is 4-bit
	movwf	_act_del_rom
	movf	_opcode,w
	lslf	9,w
	rlf		_act_del_rom
	lslf	9,w
	rlf		_act_del_rom
	bsf		_act_flags,3 ;	act_flags |= AF_DEL_ROM;
	return

; void op_register_to_c ()
_op_register_to_c:
  movf    _op6,w          ; if (op6)
  movf    9,w
  btfsc    3,2
  goto    l_124
  movlw   0F0h
  andwf   _act_ram_addr    ; act_ram_addr = (act_ram_addr & 0xF0) | op6;
  movf    _op6,w             ; op6=opcode>>6, upper 4 bit of opcode
  iorwf    _act_ram_addr
l_124:
	movf    _act_ram_addr,w    ;	register_to_c(act_ram_addr);
  goto    _register_to_c

; 16 Register lschen ab ram_addr & 0xF0 HP-25
; QC passed 29.10.2017
_op_clear_data_regs:
  movlb   0
  movlw   0Fh
  andwf   _act_ram_addr,w   ;	uint8_t baseaddr = act_ram_addr & 0xF0; // must be multiple of 16 registers 0x10, 0x20 etc 
  call    _getrampt     ; getrampt(baseaddr);
  clrf    _first
  movlw   111          ; clear 2 RAMBANKS each 56 byte  last=2*RAMBANKSIZE*sizeof(creg_t)-1
  movwf   _last
  goto    _reg_zero

; void op_del_sel_grp()
_op_del_sel_grp:
  movlb   0
  bcf     _act_del_rom,3
  btfsc   _opcode,7
  bsf     _act_del_rom,3    ; act_del_rom = (uint8_t)(act_del_rom & 0x07 | (uint8_t)((opcode >> 4) & 0x08)); // set bit 11 from bit 7
  return

; void op_test_p()
_op_test_p:
  movlb   0
  movf   _op6,w
  xorwf  _act_p,w       ; if(act_p == op6)
  btfsc   3,2
  bcf    _act_flags,1   ; act_flags |= AF_CARRY;
  return

; m_to_register(uint8_t addr)
_m_to_register:
  call    _getrampt   ; dest=act_ram[addr]
  BANKSEL (_act_m)
  movf    BANKMASK(_act_m),w
  movlb   0
  movwf   _src
  BANKSEL (_act_m)
  movf    BANKMASK(_act_m+1),w
  movlb   0
  movwf   _src+1    ; src=act_m;
  call    _reg_copy
  return

;register_to_m(uint8_t addr)
_register_to_m:
  call    _getrampt   ; dest=act_ram[addr]
  movf    _dest,w
  movwf    _src
  movf    _dest+1,w
  movwf    _src+1    ; src=dest;
  BANKSEL (_act_m)
  movf    BANKMASK(_act_m),w
  movlb   0
  movwf    _dest
  BANKSEL (_act_m)
  movf    BANKMASK(_act_m+1),w
  movlb   0 
  movwf    _dest+1    ; dest=act_m;
_creg_copy:
  clrf    _first    ; first=0; last = WSIZE/2-1;
  movlw    6
  movwf   _last
  call    _reg_copy  ;	copy act_m to act_ram[addr]
  return;

; classic command
_op_data_to_c:
  movlb   0
  movf    _act_ram_addr,w  ;  register_to_c(act_ram_addr);

#endasm

#ifdef HP01

#asm
; speed and size optimized assembler routines for HP-01 ACT arithmetic core

; following instructions are only used by HP-01 firmare
gettestmap01:
  movlw    low (_p_test_map01 | 32768)
  movwf    FSR0L
  movf     _op6,w
  addwf    FSR0L
  movlw    high (_p_test_map01 | 32768)
  clrf     _dest
  addwfc   _dest,w
  movwf    FSR0H  
  movf     INDF0,w
  return

_op_test_p_eq01:
  movlb   0
  movlw   1
  movwf   _act_inst_state  ;	act_inst_state = branch;
	bsf     _act_flags,1   ; act_flags |= AF_CARRY;
  call    gettestmap01
  subwf    _act_p,w     ; if (act_p == p_test_map [op6])
  btfsc    3,2
	bcf     _act_flags,1   ; act_flags &=~AF_CARRY;
  return

_op_test_p_ne01:
  movlb   0
  movlw   1
  movwf   _act_inst_state  ;	act_inst_state = branch;
	bcf     _act_flags,1   ; act_flags &= ~AF_CARRY;
  call    gettestmap01
  subwf    _act_p,w     ; if (act_p == p_test_map [op6])
  btfsc    3,2
	bsf     _act_flags,1   ; act_flags |=AF_CARRY;
  return

_op_load_constant01:
  movlb  0
  movlw  12
  subwf  _act_p,w
  btfsc  3,1
  goto   l_0125
	movf	_act_p,w
	addlw	low _act_a
	movwf	FSR1L
	movlw	high _act_a
	movwf	FSR1H
  movf  _op6,w
	movwf	INDF1 ; act_c [act_p] = opcode >> 6;
l_0125:
  goto  _op_dec_p

_op_display_on:
  movlb   0
	bsf   _act_flags,5    ; act_flags |= AF_DISPLAY_ON;
  return

_op_clr_s17:
  movlb   0
  clrf   _act_s          ;  act_s &=0xFF00;
  return

_op_clr_s815:
  movlb   0
  clrf   _act_s+1       ; act_s &=0x00FF;
  return

_op_sleep:
  movlb   0
  bsf   _hp01flags,0   ;  hp01flags |= F_SLEEP;
  return

_op_blink:
  movlb   0
  bsf   _hp01flags,1    ; hp01flags |= F_BLINK;
  return

_op_enscwp:
  movlb   0
  bsf   _hp01flags,2     ; hp01flags |= F_SCWP;
  return

_op_dsscwp:
  movlb   0
  bcf   _hp01flags,2     ; hp01flags &= ~F_SCWP;
  return

_op_swinc:
  movlb   0
  bcf   _hp01flags,3     ; hp01flags &= ~F_SWDEC;
  return

_op_swdec:
  movlb   0
  bsf   _hp01flags,3     ; hp01flags |= F_SWDEC;
  return

_op_swstrt:
  movlb   0
  bsf   _hp01flags,4     ; hp01flags |= F_SWSTARTED;
  return

_op_swstop:
  movlb   0
  bcf   _hp01flags,4     ; hp01flags &= ~F_SWSTARTED;
  return

_op_altog:
  movlb   0
  movlw    32
  xorwf   _hp01flags     ;  hp01flags ^= F_ALARMACTIV;
  return

_op_cdex:
  movlb   0
  movlw  low _act_reg
  movwf  _dest
  movlw  high _act_reg
  movwf  _dest+1   ;  dest = act_reg;
  movlw  low _act_y
  movwf  _src
  movlw  high _act_y
  movwf  _src+1    ; src = act_y;
  clrf  _first   ;  first = 0;
  movlw  6
  movwf  _last    ; last = WSIZE/2 - 1;
  call   _reg_copy    ;  // make a copy of act_y
  movlw  low _act_c
  movwf  _src
  movlw  high _act_c
  movwf  _src+1           ; src = act_c;
  movlw  low _act_y
  movwf  _dest
  movlw  high _act_y
  movwf  _dest+1    ; dest = act_y;
  call   _reg_compress    ; copy act_c to act_y
  movlw  low _act_reg
  movwf  _src
  movlw  high _act_reg
  movwf  _src+1           ; src = act_reg;
  movlw  low _act_c
  movwf  _dest
  movlw  high _act_c
  movwf  _dest+1    ; dest = act_c;
  call   _reg_decompress    ; copy temporary reg to act_c
  return

_op_ctom_
  movlb   0
  movlw  low _act_c
  movwf  _src
  movlw  high _act_c
  movwf  _src+1           ; src = act_c;
  movlw  low _act_m
  movwf  _dest
  movlw  high _act_m
  movwf  _dest+1    ; dest = act_m;
  call   _reg_compress    ; copy act_c to act_m
  return

_op_dtoc:
  movlb   0
  movlw  low _act_y
  movwf  _src
  movlw  high _act_y
  movwf  _src+1           ; src = act_c;
  movlw  low _act_c
  movwf  _dest
  movlw  high _act_c
  movwf  _dest+1    ; dest = act_m;
  call   _reg_decompress    ; copy act_y to act_c
  return

_op_ftoap:
  movlb   0
  movlw    low _act_a
  addwf   _act_p,w
  movwf   FSR0L
  clrf    _dest
  movlw   high _act_a
  addwfc  _dest,w
  movwf   FSR0H
  movf    _act_f,w
  movwf   INDF0       ;  act_a[act_p]=act_f;
  return

_op_aptof:
  movlb   0
  movlw    low _act_a
  addwf   _act_p,w
  movwf   FSR0L
  clrf    _dest
  movlw   high _act_a
  addwfc  _dest,w
  movwf   FSR0H
  movf   INDF0,w
  movwf    _act_f   ;  act_f=act_a[act_p];
  return


_op_dsptoa:
  movlb   0
  movlw  low _act_dsp
  movwf  _src
  movlw  high _act_dsp
  movwf  _src+1           ; src = act_dsp;
  movlw  low _act_a
  movwf  _dest
  movlw  high _act_a
  movwf  _dest+1    ; dest = act_a;
  goto   _reg_copy01    ; copy act_dsp to act_a


_op_cltoa:
  movlb   0
  movlw  low _act_cl
  movwf  _src
  movlw  high _act_cl
  movwf  _src+1           ; src = act_cl;
  movlw  low _act_a
  movwf  _dest
  movlw  high _act_a
  movwf  _dest+1    ; dest = act_a;
  goto   _reg_copy01    ; copy act_cl to act_a
  return

_op_atoal:
  movlb   0
  movlw  low _act_a
  movwf  _src
  movlw  high _act_a
  movwf  _src+1           ; src = act_a;
  movlw  low _act_al
  movwf  _dest
  movlw  high _act_al
  movwf  _dest+1         ; dest = act_al;
  bsf    _hp01flags,5   ; hp01flags ^= F_ALARMACTIV;
  goto   _reg_copy01       ; copy act_a to act_al

_op_atocl:
_op_atoclrs:
  movlb   0
  movlw  low _act_a
  movwf  _src
  movlw  high _act_a
  movwf  _src+1           ; src = act_a;
  movlw  low _act_cl
  movwf  _dest
  movlw  high _act_cl
  movwf  _dest+1    ; dest = act_cl;
_reg_copy01:
  clrf    _first   ;  first = 0;
  movlw   5        ;  last = WSIZE01 - 1;
  movwf  _last
  call   _reg_copy    ; copy act_a to act_cl
  return

_op_cltodsp:
;  act_dsp[4] = act_cl[0];
;  act_dsp[5] = act_cl[1];
;  act_dsp[7] = act_cl[2];
;  act_dsp[8] = act_cl[3];
  BANKSEL  (_act_cl)
  movf    BANKMASK(_act_cl),w
  movwf   BANKMASK(_act_dsp+4)
  movf    BANKMASK(_act_cl+1),w
  movwf   BANKMASK(_act_dsp+5)
  movf    BANKMASK(_act_cl+2),w
  movwf   BANKMASK(_act_dsp+7)
  movf    BANKMASK(_act_cl+3),w
  movwf   BANKMASK(_act_dsp+8)
  return

_op_swtoa:
  movlb   0
  movlw  low _act_sw
  movwf  _src
  movlw  high _act_sw
  movwf  _src+1           ; src = act_sw;
  movlw  low _act_a
  movwf  _dest
  movlw  high _act_a
  movwf  _dest+1          ; dest = act_a;
  goto   _reg_copy01      ; copy sw to a


_op_atosw:
  movlb   0
  movlw  low _act_a
  movwf  _src
  movlw  high _act_a
  movwf  _src+1           ; src = act_a;
  movlw  low _act_sw
  movwf  _dest
  movlw  high _act_sw
  movwf  _dest+1          ; dest = act_sw;
  goto   _reg_copy01      ; copy a to sw

_op_atodsp:
  movlb   0
  movlw  low _act_a
  movwf  _src
  movlw  high _act_a
  movwf  _src+1           ; src = act_a;
  movlw  low _act_dsp
  movwf  _dest
  movlw  high _act_dsp
  movwf  _dest+1          ; dest = act_dsp;
  goto   _reg_copy01      ; copy a to dsp

_op_altoa:
  movlb   0
  movlw  low _act_al
  movwf  _src
  movlw  high _act_al
  movwf  _src+1           ; src = act_al;
  movlw  low _act_a
  movwf  _dest
  movlw  high _act_a
  movwf  _dest+1          ; dest = act_a;
  goto   _reg_copy01      ; copy al to a

#endasm

#endif // HP01
#endif // USEASAM
