#include <stdint.h>
#include "act.h"
#include "bcd.h"

// increment BCD number pointed by pt with n bytes, each byte is two digits
void IncrementBCD(uint8_t *pt,uint8_t bytes,uint8_t limit)
{
	uint8_t i;
	for(i=0;i<bytes;i++)
	{
		if((++pt[i]&0x0f)>9)
			pt[i]+=6;
		if(pt[i]>limit)
			pt[i]=0;
		else
			break;
	}
}

// convert 32-bit number n into normalized BCD number in act_reg
void ConvertHex2BCD(uint8_t *pt,uint32_t n)
{
uint8_t i,a;
	
  act_reg[WSIZE-1]=0;  // produce unsigned only positive numbers
  act_reg[WSIZE-1-11]=0;  // positive exponent
  act_reg[WSIZE-1-12]=0;  // start with exponent 09
  act_reg[WSIZE-1-13]=9;
	 
	for(i=10;i>0;i--) // 10 digits mantissa
	{
		 a=n%10;
		 n=n/10;
		 act_reg[WSIZE-1-i]=a;
	}
	reg_normalize((uint8_t *)act_reg);
	dest=pt;
	src=act_reg;
	reg_compress();
}

// convert BCD number to 32-bit unsigned integer
// BCD numbers <1 return 0
uint32_t ConvertBCD2Hex(uint8_t *reg)
{
uint8_t i,exponent;

  if(reg[2]==9) // exponent negativ ?
		 return 0;  // number<1
		 
	uint32_t n=reg[WSIZE-1-1]; // first significant digit
	exponent=reg[1]*10;
  exponent+=reg[0];
  i=2;
	while(exponent-->0)
	{
		n=(n<<3) + (n<<1);  // *8 + *2 = *10 faster than n*=10;
		if(i<WSIZE-3)
			n+=reg[WSIZE-1-i];  // contains mantissa
		i++;
	}
	if(reg[WSIZE-1]==9)
      n=-n;
	return n;
}
