#include "stdint.h"
#include "stdbool.h"
#include "version.h"

// supported calculators up to 32
#define MAXCALCULATORS  20
#ifdef SPICE
#define FIRSTCALCULATOR 5
#define NROFCALCULATORS 11  // highest model HP-38
#else
#define FIRSTCALCULATOR 0
#define NROFCALCULATORS 17
#endif
// Flashvars area
#define USERFLAGSADDR   0 // 16 byte
#define SERIALNRADDR   32 // 5 byte
#define HPSERIALNRADDR 37 // 10 byte
#define VERSIONADDR    48 // 2 byte
 
// 5 Columns RB1-RB5
// RB7,RB6 ICSP interface
// 6 rows RA0-RA5 same as digits
// 9 digits RE0-RE2, RC2 same as rows
// 9 segments RD0-RD7, RC3
// RC0,RC1 T1OSO 32768 kHz RTC crystal
// TX RC6 Row 10
// RX RC7 Row 11

#define INT     PORTBbits.RB0 // I Interrupt Input
#define COL1	  PORTBbits.RB1 // I keyboard column 1
#define COL2	  PORTBbits.RB2 // I keyboard column 2
#define COL3	  PORTBbits.RB3 // I keyboard column 3
#define COL4	  PORTBbits.RB4 // I keyboard column 4
#define COL5	  PORTBbits.RB5 // I keyboard column 5
#define CLKOUT  PORTCbits.RC0  // I 1Hz, 1024Hz, Time signal
#define BUZZER	LATCbits.LATC2 // O PWM for Buzzer and IR print diode
#define SCK     LATCbits.LATC3 // O SPI clock
#define SDO     PORTCbits.RC4  // I SPI Data Out
#define SDI     LATCbits.LATC5 // O SPI Data In
#define TX      LATCbits.LATC6 // O RS232 Transmit
#define RX      LATCbits.LATC7 // I RS232 Receive

#define SELA	  LATAbits.LATA0 // O display/keyboard row select A
#define SELB	  LATAbits.LATA1 // O display/keyboard row select B
#define SELC	  LATAbits.LATA2 // O display/keyboard row select C
#define SEMI	  LATAbits.LATA5 // O segment semicolon fr SPICE display
#define SEL1 	  LATAbits.LATA6 // O display/keyboard row select enable
#define SEL2 	  LATAbits.LATA7 // O display/keyboard row select enable
#define CE      LATEbits.LATE0 // O Chip enable PCF2127
#define CE2     LATEbits.LATE1 // O Chip enable SST25PF040 Flash
#define ENABLEGPS	LATEbits.LATE2 // O Enable Power for GPS Module (high active)
#define PRGMRUN PORTAbits.RA4  // I PRGM/RUN switch

#define SLEEPTIME 60 // sleep time s for reduced current standby mode
#define REPEATTIME 60
#define PAUSETIME 100
#define PRELLTIME 5 // 2-5 Zyklen 10 ist zu langsam
#define LOWVOLTAGE 230 // Battery Low Voltage 2,3 V
#define HP25APPLICATIONPROGRAMS 82
#define HP29APPLICATIONPROGRAMS 50
#define STANDARDPACPROGRAMS 18

#define TICKEREOT 0x7F

#define DISPCALCULATOR 0
#define DISPDATE 1
#define DISPTIME 2
#define DISPALARM 3
#define DISPDAY 4
#define DISPTEXT 5
#define DISPVOLTAGE 6
#define DISPTEMP 7
#define DISPSTOPWATCH 8
#define DISPHEXENTRY 9
#define DISPOPERATINGHOURS 10
#define DISPMEMORY 11
#define DISPUSERFLAGS 12
#define DISPUSERSTRING 13
#define DISPLOGO 14
#define DISPDIRECTORY 15
#define DISPNMEA 16
#define DISPFMRADIO 17
#define DISPROM 18

// flags
#define F_REMOTEKEY     (1<<0) // Remote Key received
#define F_SLIDERRIGHT   (1<<1) // Slider switch right side
#define F_WAKEUPKEY    	(1<<2) // Wakeup key
#define F_SHOWMNEMONIC  (1<<3) // show Program step mnemonic
#define F_PRGMRUN		    (1<<4) // RUN/PRGM Switch
#define F_PROGRAMMABLE  (1<<5) // calculator is programmable
#define F_TIMEENTRY     (1<<6)
#define F_SHOWINFO      (1<<7) // Show info text

// flags1
#define F_TICK          (1<<0)
#define F_DISPTICK      (1<<1)
#define F_ENTERPRNAME   (1<<2)
#define F_SHOWKEY       (1<<3)
#define F_LOWBATT       (1<<4)
#define F_SHOWPI        (1<<5)
#define F_TIMESTARTED   (1<<6)
#define F_SHOWHEX       (1<<7)

// flags2
#define F_WAITIDLE      (1<<0)
#define F_WAITKEY2ROM   (1<<1)
#define F_OCTMODE       (1<<2)
#define F_PREFIX        (1<<3)
#define F_DOUBLEPREFIX  (1<<4)
#define F_PRESSENTER    (1<<5)
#define F_COMPAREPRGM   (1<<6)
#define F_ISEMPTYPRGM   (1<<7)

// flags3
#define F_PRINTX        (1<<0)
#define F_FIRSTSTEP     (1<<1)
#define F_FAHRENHEIT    (1<<2)
#define F_INFOTEXT      (1<<3)
#define F_DISPLAYOFF    (1<<4)
#define F_SPISTOPPED    (1<<5)
#define F_SHOWPROGRAMNR (1<<6)
#define F_SHOWSERIAL    (1<<7)

// flags4
#define F_RTCINIT       (1<<0) // RTC initialized
#define F_ALARMDAILY    (1<<1)
#define F_BEEP          (1<<2) // Beep active
#define F_HOUR          (1<<3) // full hour read
#define F_SHOWPRGM      (1<<4) // Show Program/Register Usage
#define F_OSFERROR      (1<<5) // Oscillator stop flag set
#define F_MSINT         (1<<6) // minute second interrupt
#define F_OFF           (1<<7) // Power switched OFF

// classicflags
#define F_TIMER         (1<<0) // HP-55 Timer
#define F_FKEYPRESSED   (1<<1) // f key was pressed
//#define F_FKEYRELEASED  (1<<2) // f key is released
#define F_FKEYDOWN      (1<<3)
#define F_BZERO         (1<<5)

// TypeFlags
#define TF_21_22_27_67  (1<<0)
#define TF_21_29_27     (1<<1)
#define TF_21_27_67     (1<<2)
#define TF_29_34_67     (1<<3)
#define TF_CLASSIC      (1<<4)
#define TF_SPICE        (1<<5)
#define TF_ACTN         (1<<6)
#define TF_SLIDER       (1<<7)

// keyflags  keyboard actions
#define KF_SUPRESSKEY   (1<<0)
#define KF_ALLOWKEY     (1<<1)
#define KF_FUNCTION     (1<<2)
#define KF_SHOWREGISTER	(1<<3)
#define KF_CLEARPREFIX  (1<<4)
#define KF_SHOWINFO     (1<<5)
#define KF_STOPRGM      (1<<6)
#define KF_RCLPRGM      (1<<7)
#define KF_SHOWPROGRAM  (1<<8)
#define KF_GTOSTEP     	(1<<9)
#define KF_DOT          (1<<13)
#define KF_FIRSTDIGIT   (1<<14)
#define KF_REPEATKEY    (1U<<15)

// prefix flags
#define PF_FKEY		      (1<<0)
#define PF_GKEY	        (1<<1)
#define PF_HKEY         (1<<2)
#define PF_GTOKEY       (1<<3)
#define PF_RCLKEY       (1<<4)
#define PF_STOKEY       (1<<5)
#define PF_FFKEY        (1<<6)
#define PF_GGKEY        (1<<7)

// user_flags  stored in Continuous Memory, dont change order
#define UF_SLEEPMODE 	(1<<0)
#define UF_SHOWLOGO   (1<<1)
#define UF_BATTCHECK	(1<<2)
#define UF_SHOWANNUNC	(1<<3)
#define UF_REPEAT       (1<<4)
#define UF_RIGHTADJUST  (1<<5)
#define UF_SYMBOLDISPLAY (1<<6)
#define UF_SHOWMNEMONIC (1<<7)
#define UF_DATEUS       (1<<8)	
#define UF_TIMEAMPM     (1<<9)	
#define UF_HP82240      (1<<10)	
#define UF_PRINTNORM   (1<<11)
#define UF_PRINTTRACE   (1<<12)
#define UF_WAKEUPALLKEYS (1<<13)
#define UF_LONGSLEEP    (1<<14)
#define UF_STEADYDISP   (1<<15)

// user_flags1 
#define UF_RUNTIME       (1<<0)
#define UF_KEEPREGISTERS (1<<1)
#define UF_SHOWKEY       (1<<2)
#define UF_RES3     (1<<3)
#define UF_RES4     (1<<4)
#define UF_RES5     (1<<5)
#define UF_HP21HW   (1<<6)
#define UF_FCNTABLE (1<<7)

extern uint16_t rombuf[32] @ 0x420;
extern uint8_t rombuf8[64] @ 0x420;
extern char TickerText[] @ 0x420; // share ram with rombuf
extern uint16_t user_flags;
extern uint8_t user_flags1;
extern uint8_t flags @ 0x4bc;
extern uint8_t flags1;
extern uint8_t flags2;
extern uint8_t flags3;
extern uint8_t flags4;
extern uint8_t classicflags;
extern uint8_t TypeFlags;
extern uint8_t HPType,HPTypeNr;
extern uint16_t MotorRunning;
extern uint8_t PrintCharCount;
extern uint8_t DisplayNr;
extern uint8_t ReceiveTimeout;
extern uint8_t RemoteKey;
extern uint8_t RunBit;
extern uint8_t keycode;
extern uint8_t MaxProgramSteps;
extern uint16_t annuncmask;
extern uint16_t WaitKeyReleasedAddr;
extern uint8_t DebugCommand;

extern volatile uint16_t romdata;	 // 10 bit opcode
extern uint16_t keyflags;
extern uint8_t SleepCnt;
extern uint16_t PauseCnt;
extern uint16_t TimerCnt;
extern uint16_t SWStartTime;

void Wait8ms(uint8_t n);
void ClearInfo();
void ShowDisplayNr();
void SetupHPType();
void ShowLogo();
void ShowText(char n);
void StartDisplay();
void StopDisplay();
void DoShowROM();
void DoUserStringEntry();
void CheckAddress();
void ReadText(uint8_t TextNr);
void DelayTicks(uint8_t ticks);
void SetRightShift();
void ShowPI();
void SwitchCalculator();
void TriggerSleepTime();
void RemoteDataReceived();

void ShowVoltage();
void ShowTemperature();
void ShowProgramName();

void WritePage(uint16_t addr,uint16_t pt);
void Writerombuf(uint8_t page,uint16_t addr);
void Readrombuf(uint8_t page,uint16_t addr);

void ReadStopwatch();

