/*
 *  keyboard.c
 *  
 *
 *  Created by Bernhard Emese
 *  Copyright 2018 Panamatik. All rights reserved.
 *
 */

#include "hp25lp.h"
#include "display.h"
#include "act.h"
#include "keyboard.h"
#include "sst25pf040.h"

uint8_t prefixflags;
uint8_t keyindex;
volatile uint8_t prellcnt;
volatile uint8_t keypressed;
volatile uint8_t hpcode;
volatile uint8_t lastcolumncode;

static volatile uint8_t LastColumnCode;
static volatile uint8_t delayedkey;
volatile uint8_t ColumnCode; // actual columncode
volatile uint8_t keycolumn,keyrow;

// calculate ColumnCode from KeyRow ColumnMask
// return: ColumnCode contains keyboard row (1-7) in upper nibble and column (1-5) in lower nibble;
// will be called by interrupt, don't use subroutines
void GetColumnCode()
{
uint8_t i,mask;

  ColumnCode=0;
  if(keyrow)  // key pressed in any row? check keyrow und columncode
  {
    mask=0x02;
    for(i=1;i<=COLUMNS;i++,mask<<=1)
    {
      if((keycolumn & mask)==0) // suche Tastenmatrix spalte von 1-5
      {
#ifdef SPICE
          if(keyrow>=4)
          {
            if(--i==0) // rotate column
             i=5;
          }
#endif
#ifdef HP21HW
// only for testing LP hardware on HP-21 board
        if(user_flags1 & UF_HP21HW) // HP-21 Hardware has rotated key columns
        {
          if(++i==6) // rotate column
           i=1;
        }
#endif
        ColumnCode=keyrow<<4 | i;
        break;
      }
    }
  }
}

// berechne den Keycode anhand der gedrckten Taste, wird bei tastendruck und beim Loslassen aufgerufen
// will be called by interrupt, dont use subroutines
// input : ColumnCode 
// output: hpcode, keypressed
void readkeys()
{
  if(HPType==0x67 /*|| (TypeFlags & TF_CLASSIC && HPType>=0x55)*/) // Classic keyboard with 8 rows but no Longpress
  {
  	if(ColumnCode)  // columncode combined row and column
	  {
		  if((ColumnCode & 0xF0)==0x10)  // key in first row ?
		  {
        if(classicflags & F_FKEYDOWN) // button in first row pressed while f key is hold down ?
  		  {
				  ColumnCode&=0x0f; // change row 1 -> row 0, simulate nonexistent row 0
				  classicflags &=~F_FKEYPRESSED; // release f key without processing
				  LastColumnCode=0; // force keypressed event with real first row button
				}
		  }
			else // any other key row than first row pressed?
			{
				if(classicflags & F_FKEYDOWN && !(classicflags & F_FKEYPRESSED) ) // button in first row released and f still pressed?
					ColumnCode=0;  // force key released for next first row key press
			}
    } 
    else  if(classicflags & F_FKEYPRESSED) // Classic f Taste losgelassen?
    {
//	    classicflags&=~F_FKEYDOWN; // no f key pressed anymore, clear FKEYDOWN, keep F_KEYPRESSED
      ColumnCode=LastColumnCode;
      goto L3;
    }
  }

  if(ColumnCode==0 && delayedkey) // long press method, Taste nur kurz gedrckt LastColumnCode=0
  {
		 ColumnCode=delayedkey;  // code of row=1
		 prellcnt=PRELLTIME;  // cause release key event after short time
//     lastcolumncode=ColumnCode;
     goto L3;
  }

	if(ColumnCode && LastColumnCode==0) // key pressed ?
	{
    if(DisplayNr==DISPCALCULATOR && (HPType==0x67 || (TypeFlags & TF_CLASSIC))) // Longpress method
    {
// long press version for HP-35, doesnt work for HP-67, because SST button must be possible to hold down
			if((ColumnCode & 0xF0) == 0x10)  // erste Tasten Reihe ? long press version
			{
				if(delayedkey==0)
				{
          if(HPType!=0x67 || (ColumnCode & 0x0f)==0x01)  // nur A Taste bei HP67
          {
					  delayedkey=ColumnCode; // merke ColumnCode fr event nach dem Loslassen
					  prellcnt=100; // starte ca 1 s Entprellzeit, danach wird readkeys erneut aufgerufen
					  return; // don't set LastColumnCode
          }
				} else    // Taste lange gedrckt ? 1 s
        {
					ColumnCode&=0x0f;  // row 0  long press, Taste ist lang gedrckt
        }
			}
    }

L3:
		delayedkey=0;
    hpcode=ColumnCode; // latch hardware independent keycode for all woodstocks and spice

		if(!(flags & F_WAKEUPKEY) /*|| HPType==0x01*/) // supress first key after Sleep mode, not if HP01
			keypressed|=KP_PRESSED;  // pressed

    flags&=~F_WAKEUPKEY;
	}

  if(ColumnCode==0 && LastColumnCode!=0) // key released ?
		  keypressed|=KP_RELEASED; // released

  LastColumnCode=ColumnCode;
}


// will be called by any keypress
void CheckPrefixKeys()
{
uint8_t fkey,gkey;

  	fkey=FKEY;      // set defaut Prefix key for HP-25 and HP-21 keyboard
	  gkey=GKEY;      // set defaut Prefix key for HP-25 and HP-21 keyboard

    if(HPType==0x22)
    {
       gkey=FKEY; // HP-22 has only f key, but also g key sequences
    }

	// check prefixkeys
		prefixflags&=~PF_RCLKEY;
		prefixflags&=~PF_STOKEY;
		prefixflags&=~PF_GTOKEY;  // check GTO,RCL,STO prefix pressed 
		if(!(prefixflags & PF_FKEY) && !(prefixflags & PF_GKEY)) //  only when f or g prefix not pressed before
		{
			if(keyindex==GTOKEY)
				prefixflags|=PF_GTOKEY;
			if(keyindex==RCLKEY)
				prefixflags|=PF_RCLKEY;
			if(keyindex==STOKEY)
				prefixflags|=PF_STOKEY;
		}

		prefixflags&=~PF_GGKEY;
		prefixflags&=~PF_FFKEY;
		if(prefixflags & PF_FKEY && keyindex==fkey)  // HP-29 needs double f KEY for SST
			prefixflags|=PF_FFKEY; // double f key pressed
		if(prefixflags & PF_GKEY && keyindex==gkey)  // HP-29 needs double g KEY for Functions in PRGM mode
			prefixflags|=PF_GGKEY; // double g key pressed

		prefixflags&=~PF_FKEY; // check f or g or h prefix key pressed ?
		prefixflags&=~PF_GKEY;
		prefixflags&=~PF_HKEY;
		if(keyindex==fkey)     // register prefix keys after FKEY GKEY are processed
			prefixflags|=PF_FKEY;
		if(keyindex==gkey)
			prefixflags|=PF_GKEY;
		if(keyindex==HKEY)
			prefixflags|=PF_HKEY;
}

// Get calculator specific keycode from software independent keyboard code
// rowcode bit4-7 row 1-7 bit 0-3 column 1-5
uint8_t GetKeyCode(uint8_t rowcode)
{
uint8_t row,col,code,k;

	row=rowcode>>4;     // 0-7 row for classic 1-7 for HP-25 etc
	col=rowcode & 0x0f; // 1-5 column 1,2,3,4,5
	k=row<<2; k=k+row+col-1; // k=row*5 + col -1
  SST25Read(KEYCODEPAGE,KEYTABLE + ((uint16_t)HPTypeNr<<7) + k,&code,1); // read keycode from table in flash, each calculator 128 bytes
  return code;
}

// Get Index of HPKeys
uint8_t GetKeyIndex()
{
	uint8_t row,col,k,code;
	row=(hpcode>>4);     // 0-6 row
	col=(hpcode & 0x0f); // 1-5 column 
	k=row<<2;      // k=j*4
	k=k+row+col-1; // k=j*5+i much faster and compiled without multiplication
  SST25Read(KEYCODEPAGE,KEYTABLE + ((uint16_t)HPTypeNr<<7)+40 + k,&code,1); // read keycode from table in flash, each calculator 128 bytes
  return code;
}

// Get Keycode from KeyIndex
uint8_t GetIndexKeyCode(uint8_t index)
{
  uint8_t code;
  SST25Read(KEYCODEPAGE,KEYTABLE + ((uint16_t)HPTypeNr<<7)+80 + index,&code,1); // read keycode from flash table, each calculator 128 bytes
  return code;
}

