#include <stdlib.h>
#include "hp25lp.h"
#include "act.h"
#include "memory.h"
#include "storage.h"
#include "sst25pf040.h"
#include "display.h"

#ifdef SHOWMEMORY

int8_t MemoryPage;

uint8_t IsRAMRegisterEmpty(uint8_t j)
{
  getrampt(j);
	for(uint8_t i=0;i<WSIZE/2;i++)  // 7 byte each register
	{
		if(dest[i]!=0)
			return FALSE;
	}
  return TRUE;
}

// i index of Userregisterset 0-USERREGISTERS*8-1
uint8_t IsRegisterEmpty(uint8_t n)
{
  uint8_t result,i;
  uint16_t addr=STOADDR+HPTypeNr*0x500; // bringt den Rckgabewert durcheinander
  addr+=(n/8)*FPAGESIZE;
  n=(n % 8)*7;
  result=1;
  flags2|=F_ISEMPTYPRGM;
  result=RecallRegisters(REGISTERPAGE,addr+n,NULL,1);  // each register occupies 7 byte
  flags2&=~F_ISEMPTYPRGM;
  return result;
}

uint8_t ProgramEmpty(uint8_t i)
{
  flags2|=F_ISEMPTYPRGM;
	i=ReadProgram(i);  // return 1 if program is empty
	flags2&=~F_ISEMPTYPRGM;
  return i;
}

// Show Memory available  P-nn nn FrEE  number of free programs, number of free registers
void ShowMemory()
{
	uint8_t i,j,n,m;
  uint8_t regs;

	TimerCnt=0;
	n=0;
	m=0;

  regs=RegisterPages*8;

	if(flags & F_PROGRAMMABLE)
	{
		for(i=0;i<MAXPROGRAMS+USERPROGRAMS;i++)
		{
      if(ProgramEmpty(i))
	  		n++;
		}
	}
	for(i=0;i<USERREGISTERS*regs;i++)  // test 10 ram banks = 80/160 registers, 4 byte each registers
    if(IsRegisterEmpty(i))
      m++;

  if(HPType==0x67)
  {
  	for(j=0;j<58;j++)  // 16 primary + 10 secondary + 32 gap = 58 registers of 7 byte
	  {
		  if(j==16)
			  j+=32; // skip gap at ram3,ram4
      getrampt(j);
		  for(i=0;i<WSIZE/2;i++)  // test 7 byte each register
		  {
			  if(dest[i]!=0)
			  	goto l2;
		  }
		  m++;
l2:;
	  }
  } 
  else
  {
  if(HPType==0x29) // || HPType==0x19)
    regs=16+14; // HP29 16 direct and 14 indirect registers
  else
    regs=8; // HP-25

	for(j=0;j<regs;j++)  // registers of 7 byte=56 byte
	{
    if(IsRAMRegisterEmpty(j))
      m++;
	}
  }

  ReadText(13); // "FREE",8);

	act_reg[WSIZE-1-0]='P';  // P.
  DisplayDecimal(n,1);
	act_reg[WSIZE-1-3]|=0x80;  // decimal dor between the numbers
  DisplayDecimal(m,4);

	flags3|=F_INFOTEXT;
}

// Zeigt an welche der 8 Register in den Registrersets belegt sind
// 
void ShowMemoryDetailed()
{
uint8_t n,i,j,regs;

//  ClearInfo();

  regs=RegisterPages*8; // RegisterPages is 1 or 2

  if(ProgramPages==0)   // don't show Pr if calculator is not programmable
    flags4&=~F_SHOWPRGM;

  if(!(flags4 & F_SHOWPRGM))
  {
      act_reg[WSIZE-1]='R';
      if(MemoryPage==0) // zeige register an
      {
        act_reg[WSIZE-2]='E';
        act_reg[WSIZE-3]='G';
// teste welche ram register leer sind
        for(i=0;i<regs;i++) 
        {
           if(!IsRAMRegisterEmpty(i))
           {
             if(i<8)
               act_reg[WSIZE-5-i]=i;  // show register number
             else
              act_reg[WSIZE-5-(i & 7)]|=0x80;
           }
        }
      }
      else
      {
        n=MemoryPage-1;
        act_reg[WSIZE-2]=n;

// teste welche USERREGISTER Sets leer sind
        for(i=0;i<regs;i++) // regs is 8 or 16
        {
          j=n*regs+i; // register number 0-79
          if(!(IsRegisterEmpty(j))) // compiler problem endlosschleife???
          {
            if(i<8)
              act_reg[WSIZE-5-i]=i;
            else
              act_reg[WSIZE-5-(i&7)]|=0x80;
          }
        }
      }
  }
  else   // zeige Programme an, 10 Stck pro Zeile
  {
    act_reg[WSIZE-1]='P'; // P0-P9
    if(MemoryPage==0) // zeige fast access programms
    {
       act_reg[WSIZE-2]='R'|0x80; // Pr.
       j=MAXPROGRAMS;
    } else
    {
       n=MemoryPage-1;
       act_reg[WSIZE-2]=n|0x80;
       j=n*10;
    }
    for(i=0;i<10;i++,j++)
    {
			if(!ProgramEmpty(j))
        act_reg[WSIZE-3-i]=i;
    }
  }
}

#endif // SHOWMEMORY

