#include "xc.h"
#include "hp25lp.h"
#include "act.h"
#include "sst25pf040.h"
#include "hp82240.h"
#include "keyboard.h"
#include "mnemonic.h"
#include "display.h"
#include "opcode.h"

uint16_t opcodeaddr;

#ifdef XDEBUG
// read 14-bit word
uint16_t FlashReadWord(uint16_t adr)
{
	PMADRL=adr;
	PMADRH=adr>>8 & 0x7F;
	PMCON1bits.CFGS=0;
	PMCON1bits.RD=1;
	NOP();
	NOP();
	return (uint16_t)PMDATH<<8 | PMDATL;
}

// addr flash address 0x0000-0x3FE0, bit 15 set for 14-bit writes
// pt   pointer to rombuf of 32 8-bit or 14-bit words
void WriteInternalFlash(uint16_t addr)
{
	StopDisplay();
	FlashWrite(addr|0x8000,(uint16_t)rombuf); // this writes 32 words
  Wait8ms(5);
	StartSPI();
}

void ReadInternalFlash(uint16_t addr)
{
	for(uint8_t i=0;i<FPAGESIZE/2;i++)
		rombuf[i]=FlashReadWord(addr+i);
}

#endif

// Read 10-bit opcode from ROM at act_pc
// in : act_pc, act_flags & AF_BANK, act_s, RomPage, RomAddr, HPType
// out: opcode, act_flags & AF_BANK
void ReadInternalROM()
{
  uint16_t addr=act_pc;

// internal ROM address calculation for bank switched calculators HP-67/34/38
  if(act_flags & AF_BANK /*addr>=0x1000*/) // ROM Bank 1 ?
  {
		if(addr<0x400)
			act_flags &=~AF_BANK;  // reset AF_BANK if addr < 1k
		else
    {
      if(HPType==0x67) // HP-34 8k /HP-38 6k doesn't need address correction because full 8k are used or duplicated
      {
		    if(addr<0x0800) // 1:2000 is located at 0x1000
			    addr+=0x0C00;
	    }
	    else
		    addr|=0x1000;
    }
  }

  opcodeaddr=addr; // save address for In circuit debugging 

#ifdef XDEBUG
  opcode=FlashReadWord(0x800+addr); // #define ROMADDR 0x800
#else
  SST25Read(RomPage,RomAddr + addr*2,(uint8_t *)&opcode,2); // read 2 byte from opcode flash
#endif
  opcode&=0x03ff;  // clear upper 6 bits, which could be used for fixed programs and constants
}

// Read 10-bit opcode at act_pc and check for different actions
uint16_t Getopcode()
{
uint16_t addr=act_pc;

  ReadInternalROM(); // read from internal ROM

	if(PauseCnt) // Pause verlangsamen, damit Anzeige lesbar ist
    DelayTicks(10); // wait 320 us

  if(HPType==0x34 && (act_flags & AF_BANK) && addr==03405) // start Pause instruction
    PauseCnt=PAUSETIME; // 100 = about 1 s 100*8ms

#ifndef SPICE
  if(HPType==0x67 && addr==0261)
    goto L2;
 
// Nur R/S soll program stoppen
  if(HPType==0x25)
  {
    if(addr==01754) goto L1; // Abfrage ob Taste gedrckt zum Stoppen des Programms
    if(addr==00277) goto L2; // Abfrage ob PAUSE Befehl ausgefhrt wird
  }
  else if(HPType==0x29)
  {
    if(addr==0226 || addr==05773) // Abfrage ob Taste gedrckt zum Stoppen des Programms oder bei Pause
    {
L1:   if(hpcode!=0x74 || DisplayNr!=DISPCALCULATOR) // don't accept key if Stopwatch or HexEntry is active
        act_s&=~(1<<15); // Taste nicht gedrckt simulieren wenn nicht R/S Taste
    }
    else if(addr==05765)
L2:   PauseCnt=PAUSETIME; // 100 = about 1 s 100*8ms
  } 
#endif

#ifdef MNEMONICS
// damit bei gedrckter SST BST und R/S Taste der Menmonic code angezeigt wird muss bei warten auf das Loslassen der Taste der Mnemotext angezeigt werden 
  if(addr==WaitKeyReleasedAddr)
    ShowMnemonic();
#endif

#ifndef SPICE
#ifdef HP82240
	if(user_flags & UF_HP82240)
	{
    if(HPType==0x67)
    {
		  if(addr==012435 /*012444*/ || addr == 012515 /*012526*/)  // f Print -X- or g Print STK command , print before Wait Loop
        goto L3; // SendHP82240Display();
		  if(addr==07101) // h SPACE
			  SendHP82240LineFeed();
    } else if(HPType==0x25)
    {
  		if(addr==00277)  // PAUSE is Print X command
	  		goto L3; // SendHP82240Display();
    } else if (HPType==0x29)
    {
		  if(addr==05763)  // PAUSE is Print X command
			  goto L3; // SendHP82240Display();
    }
	}
#endif
#endif

// wait until any key calculation is finished and calculator enters the idle loop
// this is the case after display is on and key flag s15 will be tested, verified for all Woodstock and Spice calculators
	if((flags2 & F_WAITIDLE) && (act_flags & AF_DISPLAY_ON) && (opcode==01734 || opcode==01724) ) // 0x3dc if 0 = s key 15, wait until idle loop is entered
	{
    if(DisplayNr==DISPCALCULATOR)
    {
#ifdef MNEMONICS
    if(!(act_flags & AF_RUNMODE)) // called when keypressed & 1
      ShowMnemonic();
#endif
    
#ifdef RIGHTSHIFT
		if(user_flags & UF_RIGHTADJUST)
			SetRightShift();
#endif
		if(flags & F_PRESSENTER)
			TimerCnt=0; // Start Timer
		if(user_flags & UF_SYMBOLDISPLAY)
			ShowPI();

		flags2&=~F_WAITIDLE; // reset flag after SetRightshift ShowPI etc. to avoid flicker

#ifdef HP82240
		if(flags3 & F_PRINTX)
		{
			flags3&=~F_PRINTX;
L3:
      DoDisplay();
			SendHP82240Display();
		}
#endif
    }
	}
	return  opcode;  // return opccode either from external or internal ROM
}

