// must be called only in PRGM mode, HP-29 and HP-25 store program nr in m at different loactions
#include "hp25lp.h"
#include "act.h"
#include "program.h"

// return 0-nnn max 224
uint8_t GetProgramStep()
{
uint8_t step,d1,d2,d3;
uint8_t *pt;

  if(HPType==0x34)
  {
    pt=(uint8_t *)ACT_RAM+47*7;
	  step=pt[1] & 0x0f; // step count from 1-7 or 0 if step=000
	  if(step!=0)
	  {
// program steps are stored in registers 0x1E-0x10 0x0E-0x00 descending = 30*7 = 210 steps, 0x0F is I register
		
	    step = (30 - pt[0])*7 + step;  // act[0] zhlt von 0x1e abwrts bis 0x00, act[1] zhlt von 1-7, Sonderfall wenn 000 
		  if(pt[0]<0x10)  // register 0x0F is skipped
			  step-=7;
	  }
	  return step;
  }

  d3=0;
  pt=(uint8_t *)ACT_RAM+8*7; // stepnr is stored in register 8 digit 3,4
#ifdef HP38
  if(HPTYpe==0x38)
  {
    if(pt[0]==0)
      return 0;
    d1=pt[0] >>4; // 0-6 upwards
    d2=pt[0] & 0x0f; // E downwards,
    if(d2==0)
      step=1; //  1.Programmschritt wird separat gespeichert!!!!  pt[0]=10
    else
      step=(14-d2)*7+d1;  // d2 14-1 = 14*7 steps = 98 
    return step;
  }  else 
#endif
  if(HPType==0x33)
  {
    pt=(uint8_t *)ACT_RAM+8*7; // stepnr is stored in register 8 digit 3,4
      d1=pt[1]>>4;
      d2=pt[2]&0x0f;
  }
  else if(HPType==0x67)
  {
    d1=act_m[WSIZE/2-2] >>4;
    d2=act_m[WSIZE/2-1] & 0x0f;
    d3=act_m[WSIZE/2-1]>>4;
  }
  else if(HPType==0x29) //  || HPType==0x19)
  {
    d1=act_m[WSIZE/2-1] & 0x0f;
    d2=act_m[WSIZE/2-1]>>4;
  } else
  {
    d2=act_m[2] & 0x0f;
    d1=act_m[1]>>4;
  }
  return 100*d3 + 10*d2 +  d1;
}

// get index from program step n 1-49 HP-25 bzw 0-98 HP-29 1-224 HP-67
uint8_t ProgramIndex(uint8_t n)
{
	uint8_t i;

	if(n>0)
  	n--;    //  n = 0-MAXPROGRAMSTEPS-1

	for(i=1;n>=7;i++)
    n-=7; //	i=(n/7)+1;

#ifdef HP38
  if(HPType==0x38)
  {
    if(n==1)
     i=-8*7;  // 1. Programmschritt ist 8 register vor dem nornmalen Programmbereich gespeichert.
    else
     i=MaxProgramSteps-n;
  }
  else
#endif
  if(HPType==0x33)  //  Programmschirtte aufwrts wie bei HP-25 aber um ein byte rotiert
  {
    n++;
    if(n==7) // step 0-6 -> 5,4,3,2,1,0,6, // HP-33
      n=0;   //             6,5,4,3,2,1,0
    goto L1;
  } else   if(HPType==0x25)
  {
L1:
    i=i*7-n - 1; // step 0-6 -> 6,5,4,3,2,1,0, HP-25
  } else  // HP-29
   	i=MaxProgramSteps-i*7+n;  // step 0-6  -> 91-97  step 7-13 -> 84-90 etc. HP-29 HP-67

  if(HPType==0x34)
  {
	  if(i>=15*7)
		  i+=7;  // skip I register 
  }
  return i;
}

// i= Programstep 0-n
uint8_t GetProgramCode(uint8_t i)
{
	uint8_t n,index;

	if(i==0)
		return 0;

	index=ProgramIndex(i);

  n=0;
  if(HPType==0x67)
    n=16;
  else if(HPType==0x29) // || HPType==0x19)
    n=32;
  else if(HPType==0x25 || HPType==0x33)
    n=9;

  getrampt(n);
	return dest[index];
}

// check whether program is empty after step
uint8_t ProgramIsEmpty(uint8_t step)
{
	uint8_t i,k;

	for(i=step;i<=MaxProgramSteps;i++)
	{
		k=GetProgramCode(i);
		if(k!=0)
			return FALSE;
	}
	return TRUE;
}


void SetProgramStep(uint8_t step)
{
	if(step<=49) // maximum GTO 49 in HP-25
	{
	  act_m[2]=(act_m[2] & 0xf0) | step/10;
	  act_m[1]=(act_m[1] & 0x0f) | (step%10)<<4; // HP-25 BCD 2-digit program step is coded in m
	}
}

void InsertProgramStep()
{
	int8_t i,j,step,dest,code;
	uint8_t *pt;

	pt=(uint8_t *)ACT_RAM+9*7; // pointer to rambank 2 lastX + 49 steps program

	step=GetProgramStep(); // HP-25 BCD 2-digit program step is coded in m

  	for(i=48;i>=1;i--) // loop over 48 programsteps to copy
	{
		j=ProgramIndex(i);
		code=pt[j]; // better compiling
	    if((code & 0x0f)<=9 && (code>>4) <=4) // GTO 00-49 instruction ?
		{
			dest=(code>>4)*10 + (code & 0x0f); // BCD->dez
			if(dest!=0 && dest>=step)
			{
				if(++dest>49)
 				 dest=0; // GTO 00
				code=((dest/10)<<4) + dest%10;
				pt[j]=code;
			}
		}
		if(i>=step) // never true if step=49
		{
			j=ProgramIndex(i+1);
			pt[j]=code;  // step 0-7  is pt[6]-pt[0]
		}
	}
	if(step==0)
		pt[6]=0; // first step GTO 00
}

// delete program step at current location with GTO correction
// and decrement program step
void DeleteProgramStep()
{
	int8_t i,j,step,dest,code;
	uint8_t *pt;

	pt=(uint8_t *)ACT_RAM+9*7;
	step=GetProgramStep(); // HP-25 BCD 2-digit program step is coded in m
	for(i=1;i<=49;i++) // loop all programsteps
	{
		j=ProgramIndex(i);
		code=pt[j];
	    if((code & 0x0f)<=9 && (code>>4)<=4) // GTO 00-49 ?
		{
			dest=(code>>4)*10 + (code & 0x0f);
			if(dest!=0 && dest>=step)
			{
				if(dest)
					dest--;
				code=((dest/10)<<4) + dest %10;
				pt[j]=code; // for i<step-1
			}
		}
		if(i>step)
		{
			j=ProgramIndex(i-1);
			pt[j]=code;  // step 0-7  is pt[6]-pt[0]
		}
	}
	pt[48-6]=0; // clear last step GTO 00

// one step backward
	SetProgramStep(step-1); // step=0 will be detected  

}

