// Empfangen von seriellen Kommandos vom PC
// V1.00 28.7.2017
// To do :

/*
Protokoll: STX Kommando n byte Daten ETX
Kommandos
STX 01 ETX // Get HPType sendet 1 byte HPType zurck, unlock Flash
STX 02 1 byte RemoteCode ETX // Remote Taste gedrckt
STX 03 ETX // Remote Taste losgelassen 
STX 04 1 byte 64k page, 2 byte address within 64k page, ETX receive binary data write to flash
STX 05 1 byte 64k page, 2 byte address within 64k page, ETX send binary data from flash
STX 06 1 byte 64k page, 2 byte address within 64k page, ETX erase Flash Page
STX 07 2 byte address, 1 byte bytes to read , read RAM
STX 08 2 byte address, 1 byte bytes to write, write RAM
STX 09 ETX sendet 12 byte date time
STX 10 ETX sendet 14 byte display 
STX 11 ETX  // Enter Bootloader 
*/

#define STX  0x02
#define ETX  0x03
#define ACK  0x06

#include "xc.h"
#include "hp25lp.h"
#include "act.h"
#include "serial.h"
#include "sst25PF040.h"
#include "keyboard.h"

#ifdef SERIALCOMMAND

extern void StartOfLine();  // Bootloader entry point

uint8_t RemoteKey;

static uint8_t BytesToReceive;
static uint8_t InCnt; // will be cleared at power up
uint8_t InBuf[8];

// examples
// 21 01 03  Jump to Boodloader
// 22 02 74 03 R/S key pressed  row 7 column 4 
// 22 03 74 03 R/S key released row 7 column 4 rowcode is not used
// 26 04 01 00 00 05 00 03 nn bytes data, write to flash page 4, block 0 (addr 0x0000), 0x0005 five 64 byte blocks
// 26 05 02 01 00 01 00 03 read from flash page 2, block 1 (0x0040) 0x0001 1 block of 64 bytes

// Der Host darf maximal STX mit 7 byte senden 0x27, STX mit 0 bytes 0x20 wird bergangen
// bit 3 muss immer 0 sein, bit 3-7 muss immer 0x20 sein
// wenn mehr byte gesendet werden als vom Befehl ausgewertet werden, wird das nicht als Fehler behandelt

// read serial bytes to buffer with ReceiveTimeout
// return TRUE if OK, FALSE if Timeout
uint8_t ReceiveBytes(uint8_t *pt,uint8_t bytes)
{
  for(uint8_t i=0;i<bytes;i++)
  {
    ReceiveTimeout=0; // wird von TimerInterrupt heruntergezhlt
    while(CheckSer()==0)
    {
      if(ReceiveTimeout>200)  // ca 600 ms
        return FALSE;
    }
    pt[i]=ReadSer();
  }
  return TRUE;
}

void SendRAMData(uint16_t addr,uint8_t size)
{
  uint8_t *pt=(uint8_t *)addr;
  for(uint8_t i=0;i<size;i++)
    WriteSer(pt[i]);
}

// Get RAM data from PC
void GetRAMData(uint16_t addr,uint8_t size)
{
  ReceiveBytes((uint8_t *)addr,size);
}

void DoSerialCommand()
{
uint8_t a,i;

  while(CheckSer())
  {
    a=ReadSer();
	  if(BytesToReceive==0)
  	{
    	if((a & 0xf8)==(STX<<4)) // skip all bytes which are not STX, bit 3 muss 0 sein wird zur Sicherheit ausgewertet falls Datenstrom asynchron ist
    	{
      	BytesToReceive=a & 0x07; // first byte contains 3-bit length, minimum 1, maximum 7 bytes
      	InCnt=0;
    	}
  	} else if(InCnt<BytesToReceive) // wait until all bytes received
  	{
  		InBuf[InCnt++]=a;
  	} else  // InBuf contains Command and 0-6 byte data
  	{
    	BytesToReceive=0;  // all bytes of this command are received, execute command

    	if(a==ETX) // check for protokoll error, if not ETX command is rejected
    	{
        WriteSer(ACK);
            
        switch(InBuf[0]) // Command
        {
        case 1: SST25WriteSR(0x00); WriteSer(HPType); break; // Sende HPType aktuell gewhlter calculator  // unlock flash memory
        case 2: RemoteKey=InBuf[1]; break; // simulate keycode key pressed
        case 3: keypressed|=KP_RELEASED; break; // simulate key released
        case 4: ReceivePCData(InBuf[1], InBuf[2] | InBuf[3]<<8); break; // write Data into external flash
        case 5: SendPCData   (InBuf[1], InBuf[2] | InBuf[3]<<8); break; // read data from external flash
        case 6: SST25Erase(InBuf[1], InBuf[2] | InBuf[3]<<8); break; // Erase flash 4k sector
        case 7: SendRAMData(InBuf[1] | InBuf[2]<<8,InBuf[3]); break; // read RAM Data
        case 8: GetRAMData (InBuf[1] | InBuf[2]<<8,InBuf[3]); break; // write RAM Data
        case 9: for(i=0;i<12;i++) WriteSer(act_cl[i]); break; // write date and time
        case 10: for(i=0;i<WSIZE;i++) WriteSer(act_dsp[i]); break; // write display register from right to left
#ifdef BOOTLOADER
        case 11: StartOfLine(); break; // jump into Bootloader
#endif
        }
        RemoteDataReceived();
      }
    }
  }
}

#endif
