#include <stdint.h>
#include "xc.h"
#include "hp25lp.h"

#include "serial.h"

#ifdef SERIALPORT
volatile char SerBuf[SERBUFSIZE];
volatile uint8_t SerInCnt;
uint8_t SerOutCnt;

/*----------------------------------------------------------------------------
; UART initialisieren 115200 Baud, 8 bit, at 16 MHz
;----------------------------------------------------------------------------*/
void InitUART()
{
	TXSTA=0x24;   // 8-bit Transmission, Transmit enabled, asynchronous mode,BRGH=1 High Speed

//	BAUDCON=0x00; // BRG16=0
//	SPBRG=26-1;   // 38400 Baud 16 MHz BRG16=0 BRGH=1
	BAUDCON=0x08; // BRG16=1
	SPBRG=35-1;     // 115200 Baud 16 MHz BRG16=1 BRGH=1  SPBRG=16MHz/4/Baudrate-1 rounded up
	RCSTA=0x80;   // serialPort enabled,8-bit receiption, enable continous receive

	SerInCnt=0;
	SerOutCnt=0;

	CREN=1;
	RCIE=1;   // enable receive interrupt
}

/*----------------------------------------------------------------------------
; receive serial byte, can be called by receive interrupt
;----------------------------------------------------------------------------*/
void ReceiveSer(char c)
{
	SerBuf[SerInCnt]=c; // read serial Data into serial receive FIFO and clear RCIF
	SerInCnt=(SerInCnt+1) & (SERBUFSIZE-1);  // Receive FIFO, dont check overrrun
  ReceiveTimeout=0;
  if(RCSTA & OERR)
  {
    CREN=0; // reset Overrun error;
    CREN=1;
  }
}

/*---------------------------------------------------------------
; sendet ein serielles byte 8-bit auf dem UART
;---------------------------------------------------------------*/
void WriteSer(unsigned char byte)
{
	TXREG=byte;
	while(TXIF==0 || TRMT==0) // wait until byte ist sent
		;
}

/*-----------------------------------------------------------------
; Prft, ob serielle Daten im Receive FIFO vorhanden sind
; return : z if no data available
;------------------------------------------------------------------*/
char CheckSer()
{
   return (SerInCnt-SerOutCnt) & (SERBUFSIZE-1);
}

/*-----------------------------------------------------------------
; liest ein serielles byte aus dem receive FIFO nach w
; return : z if no data available
;-----------------------------------------------------------------*/
char ReadSer()
{
	char c=0;
	if(SerInCnt-SerOutCnt) // sind SerInCnt und SerOutCnt unerschiedlich ?
	{
		c=SerBuf[SerOutCnt];
		SerOutCnt=(SerOutCnt+1) & (SERBUFSIZE-1);
	}
	return c;
}

#ifdef SERIALCOMMAND
void WriteStr(const char *str)
{
	char a;
	while(a=*str++)
	{
		WriteSer(a);
	}
}

void WriteHex8(uint8_t data)
{
	char a;
	a=(data>>4) +'0';
	if(a>'9') a+=('a'-'9'-1);
	WriteSer(a);
	a=(data & 0x0f) +'0';
	if(a>'9') a+=('a'-'9'-1);
	WriteSer(a);
}

void WriteHex12(uint16_t data)
{
	char a;
	a=(data>>8) +'0';
	if(a>'9') a+=('a'-'9'-1);
	WriteSer(a);
	WriteHex8(data);
}

void WriteOct12(uint16_t data)
{
	char a;
	a=(data>>9) + '0';
	WriteSer(a);
	a=((data>>6) & 0x07) + '0';
	WriteSer(a);
	a=((data>>3) & 0x07) +'0';
	WriteSer(a);
	a=(data & 0x07) + '0';
	WriteSer(a);
}

void Writeopcode(uint16_t op)
{
#if 1

	WriteSer(' ');
	WriteSer('d');
	WriteSer('w');
	WriteSer(' ');
//	WriteOct12(op);
	WriteHex12(op);
	WriteSer('h');
	WriteSer(0x0D);
	WriteSer(0x0A);

#else
	WriteSer('0');
	WriteSer('x');
	WriteHex12(op);
	WriteSer(',');
	if((Cnt & 0x0F) ==0x0F)
	{
		WriteSer(0x0D);
		WriteSer(0x0A);
	}
	Cnt++;
#endif
}

void Writepc(uint16_t pc,uint16_t op)
{
	WriteOct12(pc);
	WriteSer(':');
	Writeopcode(op);
}

void Writeregister(uint8_t reg[],uint8_t size)
{
uint8_t a;
int8_t i;

	for(i=size-1;i>=0;i--)  // write MSB first
	{
		a=reg[i] +'0';
		if(a>'9') a+=('a'-'9'-1);
		WriteSer(a);
	}
	WriteSer(0x0d);
	WriteSer(0x0a);
}

void WriteBCDregister(uint8_t reg[],uint8_t size)
{
uint8_t a;
int8_t i;

	for(i=size-1;i>=0;i--)  // write MSB first
	{
		WriteHex8(reg[i]);
	}
	WriteSer(0x0d);
	WriteSer(0x0a);
}

#endif
#endif

