#include <stdbool.h>
#include <stdint.h>
#include "xc.h"
#include "hp25lp.h"
#include "act.h"
#include "keyboard.h"
#include "stopwatch.h"

#ifdef STOPWATCH

extern uint8_t keyindex;

// Stopwatch
// store visible counter
static void StoreTime(uint8_t addr)
{
 // Beispiel 0.1234567891 = 01234567891 999 = 14 nibbles, 0h 12min 34s 56/100 exp=999 (-1)
 // act_sw          00000000123456  // 8 digits of 14 bytes used
 // Beispiel 5.123456789  = 05123456789 000 = 14 nibbles, 5h 12min 34s 56/100 exp=000
 // act_sw          00000005123456
 // Beispiel 0.000001000  = 01000000000 994 = 14 nibbles, 0h 1/100 exp=994 (-6)
 // act_sw          00000000000001
 // Beispiel 99.000000000  = 0990000000 001 = 14 nibbles, 99h exp=001
 // act_sw          00000099000000

  first=0;last=WSIZE-1;
  dest=act_reg;
	reg_zero();
	first=0;last=8-1; // copy 8 digits // shift left by 3 digits, make space for 3-digit exp
	src=act_sw; dest=&act_reg[3];  
	reg_copy();
  act_reg[0]=3;  // E03
	reg_normalize(act_reg);
	dest=act_ram1[addr];
  src=act_reg;
	reg_compress();
}

// recall visible counter
static void RecallTime(uint8_t addr)
{
 // Beispiel 0.1234567891 = 01234567891 999 = 14 nibbles, 0h 12min 34s 56/100 exp=999 (-1)
 // act_sw          00000000123456  // 8 digits of 14 bytes used
 // Beispiel 5.123456789  = 05123456789 000 = 14 nibbles, 5h 12min 34s 56/100 exp=000 ( 0)
 // act_sw          00000005123456
 // Beispiel 0.000001000  = 01000000000 994 = 14 nibbles, 0h 1/100 exp=994 (-6)
 // act_sw          00000000000001
	dest=act_sw; src=act_ram1[addr];
  reg_decompress();

  int8_t exp=6-act_sw[0]; // wenn exp=00 dann 6 mal nach rechts shiften, sonst weniger
  if(act_sw[2]==9)        // negativer exponent Zahl<1
    exp+=10; // bei exp=9 muss 7 mal geschiftet bei kleineren Zahlen mehr
    
	while(exp--) // denormalize
	{
	  dest=act_sw;
		first=0; last=WSIZE-1;
		reg_shift_right();
  }
}

void StartStopwatch()
{
      hp01flags |= F_SWSTARTED;
      TMR1ON=1;
}

void StopStopwatch()
{
  hp01flags &= ~F_SWSTARTED;
  TMR1ON=0;
  ReadStopwatch();
}

void DoStopwatchKeys()
{
	if(keyindex==CLXKEY) // R/S key
	{
    if(!(hp01flags & F_SWSTARTED))
    {
      TMR1Reset(0);
      ReadStopwatch();
    }
	}
	else if(keyindex==CHSKEY) // CHS key
	{
    if((TMR1L|TMR1H)==0) // if 0 start incrementing
      goto L3;

    hp01flags |= F_SWDEC;
    goto L2;
  } 
	else if(keyindex==RSKEY) // R/S key
	{
L3:
    hp01flags &=~F_SWDEC;
L2:
    TMR1Reset(GetSWTime());
    if(!(hp01flags & F_SWSTARTED))
    {
      StartStopwatch();
    } else
    {
      StopStopwatch();
    }
	}
	else if(prefixflags & PF_RCLKEY || prefixflags & PF_STOKEY)
	{
		if(keyindex<8) // STO RCL 0-7
		{
			if(prefixflags & PF_RCLKEY)
      {
				RecallTime(keyindex);
        TMR1Reset(GetSWTime());
			}
			else
      {
        ReadStopwatch(); // falls on the fly gespeichert wird, act_sw neu aus TMR1 Value setzen
				StoreTime(keyindex);
      }
			prefixflags&=~PF_RCLKEY;
			prefixflags&=~PF_STOKEY;
      ShowDisplayNr(); // because act_reg was used
		}
	}
}

#endif
