#include <string.h>
#include "hp25lp.h"
#include "act.h"
#include "memory.h"
#include "storage.h"
#include "SST25PF040.h"
#include "display.h"

uint8_t ProgramRegs;
uint8_t ProgramOffset;
//uint16_t CheckSum;

// recall, compare or check empty n registers, one constant or one program from flash page
// addr flash address
// pt destination pointer to act_ram
// n number of registers to read 1-8
// return : 0 if register is not empty
//          0 if register is not equal to pt
//          1 if empty or equal or copied to pt
// recall, compare or check empty n registers, one constant or one program from flash page
// addr flash addres
// pt destination pointer to act_ram
// n number of registers to read 1-8

uint8_t RecallRegisters(uint8_t page,uint16_t addr,uint8_t *pt,uint8_t n)
{
//  CheckSum=0;
	for(uint8_t i=0;i<n;i++)
	{
	    SST25Read(page,addr,rombuf8,WSIZE/2); //  and read 7 byte from flash location
		 
			for(uint8_t j=0;j<WSIZE/2;j++)
			{
				if(flags2 & F_ISEMPTYPRGM)
				{
//          CheckSum+=rombuf8[j];
				  if(rombuf8[j]!=0) // check empty
						return 0;
				}
				else if(flags2 & F_COMPAREPRGM)
				{
				  if(rombuf8[j]!=pt[j]) // check equal
						return 0;
				}
				else
				  pt[j]=rombuf8[j]; // copy
			}
		  addr+=WSIZE/2;									
			pt+=WSIZE/2;
	}
	return 1; // CheckSum==0; // true if equal or empty or copied
}

// store 8 56-bit registers or one 56 bytes into one 64 byte flash register page
// addr flash address
// pt pointer to act_ram, will always read 64 bytes although only 56 bytes are present
void StoreRegisters(uint8_t page,uint16_t addr,uint8_t *pt,uint8_t n)
{
  uint8_t size=n*7;
	src=pt; dest=rombuf8;
  first=0; last=size-1;
  reg_copy();
  if(size<FPAGESIZE) // 64
	  SST25Read(page,addr+size,&rombuf8[size],FPAGESIZE-size);

	Writerombuf(page,addr);
}


uint16_t GetProgramAddr(uint8_t nr)
{
  ProgramOffset=0;
  ProgramRegs=32;
  if(HPType==0x25 || HPType==0x33)  // HP-25 Program is located at register 9-15
  {
    ProgramOffset=9;
    ProgramRegs=7;
  }
  else if(HPType==0x29) // || HPType==0x19) // HP-29 Program is located at register 32-47
  {
    ProgramOffset=32;
    ProgramRegs=14;
  } else if(HPType==0x67)
  {
    ProgramOffset=16;
  }
  return ProgramAddr+ProgramPages*nr*FPAGESIZE;  // add base address of Program area
}

// schreibe Prgoramm in den normalen Speicherbereich (kein ROM code)
void WriteProgram(uint8_t nr)
{
  uint16_t addr=GetProgramAddr(nr);  // add base address of Program area
  uint8_t len;

 	while(ProgramRegs>0)
  {
    getrampt(ProgramOffset);
    len=ProgramRegs<9 ? ProgramRegs : 9; // 9*7=63 
		StoreRegisters(LibraryPage,addr,dest,len); // store 8 registers = 56 bytes
    ProgramRegs-=len;
    ProgramOffset+=len;
    addr+=64;
  }
}

// lese Programm aus dem normalen Programm Speicherbereich (kein ROM code)
uint8_t ReadProgram(uint8_t nr)
{
  uint16_t addr=GetProgramAddr(nr);
  uint8_t len;
  uint8_t result;

  result=1;
 	while(ProgramRegs>0)
  {
    getrampt(ProgramOffset);
    len=ProgramRegs<9 ? ProgramRegs : 9; // read 9 registers (63 byte) from 64 byte area
    result&=RecallRegisters(LibraryPage,addr,dest,len); // read 8 registers of 7 byte
    ProgramRegs-=len;
    ProgramOffset+=len;
    addr+=64;
  }
#ifdef PROGRAMNAME
	SST25Read(LibraryPage,addr-12,rombuf8,12); //  read Program Name to rombuf stored in 12 bytes at end of Program Pages
#endif
	return result;
}

// store constant into flash program bank ROM library
// each constant is stored as 7 byte uncompressed
// n constant number 0-99
// pt points to 7 byte BCD register with constant, eithr act_n or act_reg etc.
void StoreConstant(uint8_t *pt, uint8_t n)
{
 	uint16_t addr;
	uint8_t i,j;

	if(n<FIXEDCONSTANTS) // fixed constants cannot be overwritten
	{
		ShowText(56); // Save error
		return;
	}

	addr=(FCONSTADDR+n*8) & ~(FPAGESIZE-1);  // read 8 constants, 8 bytes per constant
  Readrombuf(FCONSTANTPAGE,addr); // read 64 byte page containing this constant

// replace one of the 8 constants with new constant in pt
  j=(n & 7)*8;
	for(i=0;i<7;i++)
     rombuf8[j+i]=pt[i];

  Writerombuf(FCONSTANTPAGE,addr);  // write 8 constants back to flash
}

// recall constant from flash program bank ROM library
// n constant number 0-99
void RecallConstant(uint8_t *pt, uint8_t n)
{
  SST25Read(FCONSTANTPAGE, FCONSTADDR+n*8, pt,7);  // read 7 bytes to BCD register
}

// sucht freies programm 0-n
// 255 kein freies programm gefunden
uint8_t GetEmptyProgram()
{
uint8_t i;

	i=GetProgramNr(F_COMPAREPRGM); // liefert 255 wenn kein identisches Programm vorhanden
    if(i!=255)  // identisches programm gefunden?
      return 254;
	return GetProgramNr(F_ISEMPTYPRGM); // leeres programm gefunden? 255 wenn kein Platz voehanden
}

