#include "hp25lp.h"
#include "act.h"
#include "keyboard.h"
#include "hp82240.h"
#include "sst25pf040.h"
#include "trace.h"

uint8_t GetTraceCode(uint16_t TraceTableAddr)
{
  if(keyindex==0xff) // not yet implemented for Classic
    return 0;
    
// lese alle TRACE codes von Flash
	uint8_t code=keyindex;

	if(prefixflags & PF_FKEY)
	  code+=32;
 	else if(prefixflags & PF_GKEY)
		code+=64;
 	else if(prefixflags & PF_HKEY)
		code+=96;
  SST25Read(KEYCODEPAGE,TraceTableAddr + ((uint16_t)HPTypeNr<<7)+code,&code,1);
  return code;
}

#ifdef HP82240
// check keyindex and f g prefix and print the operation if IR Printer and Trace mode is enabled
void CheckTraceKey()
{
	uint8_t code;

  code=GetTraceCode(PRINTTRACETABLE);

	if(code>0)
	{
		if((keyindex>=MINUSKEY && keyindex<=DIVKEY) || ((HPType==0x25 || HPType==0x29 || HPType==0x33) && keyindex==3 && prefixflags & PF_FKEY))  // arithmetik operator without prefix or y^x dyadic operators
    {
			SendHP82240Display(); // print number before operation
      if(user_flags & UF_PRINTTRACE)
  		  flags3|=F_PRINTX;  // print result after calculation is finished
    }
    else
		  flags3|=F_PRINTX;  // print result after calculation is finished
		SendHP82240ProgramStep(code,0); // print operator
		flags2|=F_WAITKEY2ROM;
	}
}

#endif
