#define VERSION  0x01
#define REVISION 0x05

#define HP21HW     // include HP-21 hardware adjustment
#define INLINEASM  // use INLINEASM for using act.c or USEASM for using actasm.c
#define ICDEBUG  // include In Circuit Debugger
//#define SPICE  // compile for SPICE hardware HP-31/32/33/34C/37/38

#define BOOTLOADER // compile with boot loader
#define EXTENDEDFEATURES // compile with extended feature
#define HP82240 // compile with IR Printer
#define STOPWATCH // compile with Stopwatch
#define HEXENTRY  // compile with hex/decimal conversion
#define MNEMONICS // compile with mnemonics
#define PCF2127 // compile with Real Time Clock
#define SHOWVOLTAGE // compile with voltage display
#define SHOWTEMP // compile with temperature display
#define NMEAMENU // compile with GPS
#define SERIALPORT // compile with serial port
#define SERIALCOMMAND
#define PRGMCHECKSUM
#define SHOWMEMORY
#define PROGRAMNAME
#define RIGHTSHIFT
#define LOADPROGRAM
#define CONTMEMORY
#define UNDO
#define HP67
#define SHOWKEY
//#define HPSERIALNR
//#define SHOWROM

#define MAXDIGITS 12 // number of digits
#define COLUMNS 5 // number of keyboard columns
#define ROWS 7 // number of keyboard rows

#define RAMBANKSIZE 8 // RAM is divided into banks of 8 registers each
#define RAMBANKS 8 // HP-34 and HP-67 have 8*8 registers = 8*56 byte for program and data
#define USERREGISTERS  10 // register sets
#define MAXPROGRAMS 100 // 100 library programs per calculator
#define USERPROGRAMS 10 // 10 fast access programs per calculator
#define FIXEDCONSTANTS 20 // 20 fixed constants
#define MAXCONSTANTS 100 // 100 constants

#define _XTAL_FREQ 16000000 // internal 16 MHz Oszillator, keyword for compiler

#define FALSE 0
#define TRUE  1
